<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ValidateAddonsCombinationRequest StructType
 * @subpackage Structs
 */
class ValidateAddonsCombinationRequest extends AbstractStructBase
{
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_product;
    /**
     * The assigned_addons
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $assigned_addons;
    /**
     * Constructor method for ValidateAddonsCombinationRequest
     * @uses ValidateAddonsCombinationRequest::setI_product()
     * @uses ValidateAddonsCombinationRequest::setAssigned_addons()
     * @param int $i_product
     * @param int[] $assigned_addons
     */
    public function __construct($i_product = null, array $assigned_addons = array())
    {
        $this
            ->setI_product($i_product)
            ->setAssigned_addons($assigned_addons);
    }
    /**
     * Get i_product value
     * @return int
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\ValidateAddonsCombinationRequest
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get assigned_addons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getAssigned_addons()
    {
        return isset($this->assigned_addons) ? $this->assigned_addons : null;
    }
    /**
     * Set assigned_addons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $assigned_addons
     * @return \StructType\ValidateAddonsCombinationRequest
     */
    public function setAssigned_addons(array $assigned_addons = array())
    {
        foreach ($assigned_addons as $validateAddonsCombinationRequestAssigned_addonsItem) {
            // validation for constraint: itemType
            if (!is_numeric($validateAddonsCombinationRequestAssigned_addonsItem)) {
                throw new \InvalidArgumentException(sprintf('The assigned_addons property can only contain items of int, "%s" given', is_object($validateAddonsCombinationRequestAssigned_addonsItem) ? get_class($validateAddonsCombinationRequestAssigned_addonsItem) : gettype($validateAddonsCombinationRequestAssigned_addonsItem)), __LINE__);
            }
        }
        if (is_null($assigned_addons) || (is_array($assigned_addons) && empty($assigned_addons))) {
            unset($this->assigned_addons);
        } else {
            $this->assigned_addons = $assigned_addons;
        }
        return $this;
    }
    /**
     * Add item to assigned_addons value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ValidateAddonsCombinationRequest
     */
    public function addToAssigned_addons($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The assigned_addons property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->assigned_addons[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ValidateAddonsCombinationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
