<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateFollowMeNumberRequest StructType
 * @subpackage Structs
 */
class UpdateFollowMeNumberRequest extends AbstractStructBase
{
    /**
     * The i_follow_me_number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_follow_me_number;
    /**
     * The number_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\FollowMeNumberInfo
     */
    public $number_info;
    /**
     * Constructor method for UpdateFollowMeNumberRequest
     * @uses UpdateFollowMeNumberRequest::setI_follow_me_number()
     * @uses UpdateFollowMeNumberRequest::setNumber_info()
     * @param int $i_follow_me_number
     * @param \StructType\FollowMeNumberInfo $number_info
     */
    public function __construct($i_follow_me_number = null, \StructType\FollowMeNumberInfo $number_info = null)
    {
        $this
            ->setI_follow_me_number($i_follow_me_number)
            ->setNumber_info($number_info);
    }
    /**
     * Get i_follow_me_number value
     * @return int
     */
    public function getI_follow_me_number()
    {
        return $this->i_follow_me_number;
    }
    /**
     * Set i_follow_me_number value
     * @param int $i_follow_me_number
     * @return \StructType\UpdateFollowMeNumberRequest
     */
    public function setI_follow_me_number($i_follow_me_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_follow_me_number) && !is_numeric($i_follow_me_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_follow_me_number)), __LINE__);
        }
        $this->i_follow_me_number = $i_follow_me_number;
        return $this;
    }
    /**
     * Get number_info value
     * @return \StructType\FollowMeNumberInfo
     */
    public function getNumber_info()
    {
        return $this->number_info;
    }
    /**
     * Set number_info value
     * @param \StructType\FollowMeNumberInfo $number_info
     * @return \StructType\UpdateFollowMeNumberRequest
     */
    public function setNumber_info(\StructType\FollowMeNumberInfo $number_info = null)
    {
        $this->number_info = $number_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateFollowMeNumberRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
