<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateDestGroupRequest StructType
 * @subpackage Structs
 */
class UpdateDestGroupRequest extends AbstractStructBase
{
    /**
     * The i_dest_group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_dest_group;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The add_destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $add_destinations;
    /**
     * The delete_destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $delete_destinations;
    /**
     * Constructor method for UpdateDestGroupRequest
     * @uses UpdateDestGroupRequest::setI_dest_group()
     * @uses UpdateDestGroupRequest::setName()
     * @uses UpdateDestGroupRequest::setAdd_destinations()
     * @uses UpdateDestGroupRequest::setDelete_destinations()
     * @param int $i_dest_group
     * @param string $name
     * @param int[] $add_destinations
     * @param int[] $delete_destinations
     */
    public function __construct($i_dest_group = null, $name = null, array $add_destinations = array(), array $delete_destinations = array())
    {
        $this
            ->setI_dest_group($i_dest_group)
            ->setName($name)
            ->setAdd_destinations($add_destinations)
            ->setDelete_destinations($delete_destinations);
    }
    /**
     * Get i_dest_group value
     * @return int
     */
    public function getI_dest_group()
    {
        return $this->i_dest_group;
    }
    /**
     * Set i_dest_group value
     * @param int $i_dest_group
     * @return \StructType\UpdateDestGroupRequest
     */
    public function setI_dest_group($i_dest_group = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest_group) && !is_numeric($i_dest_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest_group)), __LINE__);
        }
        $this->i_dest_group = $i_dest_group;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UpdateDestGroupRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get add_destinations value
     * @return int[]|null
     */
    public function getAdd_destinations()
    {
        return $this->add_destinations;
    }
    /**
     * Set add_destinations value
     * @throws \InvalidArgumentException
     * @param int[] $add_destinations
     * @return \StructType\UpdateDestGroupRequest
     */
    public function setAdd_destinations(array $add_destinations = array())
    {
        foreach ($add_destinations as $updateDestGroupRequestAdd_destinationsItem) {
            // validation for constraint: itemType
            if (!is_numeric($updateDestGroupRequestAdd_destinationsItem)) {
                throw new \InvalidArgumentException(sprintf('The add_destinations property can only contain items of int, "%s" given', is_object($updateDestGroupRequestAdd_destinationsItem) ? get_class($updateDestGroupRequestAdd_destinationsItem) : gettype($updateDestGroupRequestAdd_destinationsItem)), __LINE__);
            }
        }
        $this->add_destinations = $add_destinations;
        return $this;
    }
    /**
     * Add item to add_destinations value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\UpdateDestGroupRequest
     */
    public function addToAdd_destinations($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The add_destinations property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->add_destinations[] = $item;
        return $this;
    }
    /**
     * Get delete_destinations value
     * @return int[]|null
     */
    public function getDelete_destinations()
    {
        return $this->delete_destinations;
    }
    /**
     * Set delete_destinations value
     * @throws \InvalidArgumentException
     * @param int[] $delete_destinations
     * @return \StructType\UpdateDestGroupRequest
     */
    public function setDelete_destinations(array $delete_destinations = array())
    {
        foreach ($delete_destinations as $updateDestGroupRequestDelete_destinationsItem) {
            // validation for constraint: itemType
            if (!is_numeric($updateDestGroupRequestDelete_destinationsItem)) {
                throw new \InvalidArgumentException(sprintf('The delete_destinations property can only contain items of int, "%s" given', is_object($updateDestGroupRequestDelete_destinationsItem) ? get_class($updateDestGroupRequestDelete_destinationsItem) : gettype($updateDestGroupRequestDelete_destinationsItem)), __LINE__);
            }
        }
        $this->delete_destinations = $delete_destinations;
        return $this;
    }
    /**
     * Add item to delete_destinations value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\UpdateDestGroupRequest
     */
    public function addToDelete_destinations($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The delete_destinations property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->delete_destinations[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateDestGroupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
