<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerTaxationRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerTaxationRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The taxation_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\TaxationInfo
     */
    public $taxation_info;
    /**
     * Constructor method for UpdateCustomerTaxationRequest
     * @uses UpdateCustomerTaxationRequest::setI_customer()
     * @uses UpdateCustomerTaxationRequest::setTaxation_info()
     * @param int $i_customer
     * @param \StructType\TaxationInfo $taxation_info
     */
    public function __construct($i_customer = null, \StructType\TaxationInfo $taxation_info = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setTaxation_info($taxation_info);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerTaxationRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get taxation_info value
     * @return \StructType\TaxationInfo
     */
    public function getTaxation_info()
    {
        return $this->taxation_info;
    }
    /**
     * Set taxation_info value
     * @param \StructType\TaxationInfo $taxation_info
     * @return \StructType\UpdateCustomerTaxationRequest
     */
    public function setTaxation_info(\StructType\TaxationInfo $taxation_info = null)
    {
        $this->taxation_info = $taxation_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerTaxationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
