<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCustomerHuntgroupRequest StructType
 * @subpackage Structs
 */
class UpdateCustomerHuntgroupRequest extends AbstractStructBase
{
    /**
     * The i_c_group
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_c_group;
    /**
     * The i_c_ext
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_c_ext;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The hunt_sequence
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hunt_sequence;
    /**
     * The add_extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:AssignedExtensionsInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AssignedExtensionsInfo[]
     */
    public $add_extensions;
    /**
     * The del_extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $del_extensions;
    /**
     * The chg_extensions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:AssignedExtensionsInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AssignedExtensionsInfo[]
     */
    public $chg_extensions;
    /**
     * The prompt_action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prompt_action;
    /**
     * The pickup_allowed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pickup_allowed;
    /**
     * The hunt_keep_original_cli
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hunt_keep_original_cli;
    /**
     * Constructor method for UpdateCustomerHuntgroupRequest
     * @uses UpdateCustomerHuntgroupRequest::setI_c_group()
     * @uses UpdateCustomerHuntgroupRequest::setI_c_ext()
     * @uses UpdateCustomerHuntgroupRequest::setI_customer()
     * @uses UpdateCustomerHuntgroupRequest::setId()
     * @uses UpdateCustomerHuntgroupRequest::setName()
     * @uses UpdateCustomerHuntgroupRequest::setHunt_sequence()
     * @uses UpdateCustomerHuntgroupRequest::setAdd_extensions()
     * @uses UpdateCustomerHuntgroupRequest::setDel_extensions()
     * @uses UpdateCustomerHuntgroupRequest::setChg_extensions()
     * @uses UpdateCustomerHuntgroupRequest::setPrompt_action()
     * @uses UpdateCustomerHuntgroupRequest::setPickup_allowed()
     * @uses UpdateCustomerHuntgroupRequest::setHunt_keep_original_cli()
     * @param int $i_c_group
     * @param int $i_c_ext
     * @param int $i_customer
     * @param string $id
     * @param string $name
     * @param string $hunt_sequence
     * @param \StructType\AssignedExtensionsInfo[] $add_extensions
     * @param int[] $del_extensions
     * @param \StructType\AssignedExtensionsInfo[] $chg_extensions
     * @param string $prompt_action
     * @param string $pickup_allowed
     * @param string $hunt_keep_original_cli
     */
    public function __construct($i_c_group = null, $i_c_ext = null, $i_customer = null, $id = null, $name = null, $hunt_sequence = null, array $add_extensions = array(), array $del_extensions = array(), array $chg_extensions = array(), $prompt_action = null, $pickup_allowed = null, $hunt_keep_original_cli = null)
    {
        $this
            ->setI_c_group($i_c_group)
            ->setI_c_ext($i_c_ext)
            ->setI_customer($i_customer)
            ->setId($id)
            ->setName($name)
            ->setHunt_sequence($hunt_sequence)
            ->setAdd_extensions($add_extensions)
            ->setDel_extensions($del_extensions)
            ->setChg_extensions($chg_extensions)
            ->setPrompt_action($prompt_action)
            ->setPickup_allowed($pickup_allowed)
            ->setHunt_keep_original_cli($hunt_keep_original_cli);
    }
    /**
     * Get i_c_group value
     * @return int
     */
    public function getI_c_group()
    {
        return $this->i_c_group;
    }
    /**
     * Set i_c_group value
     * @param int $i_c_group
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setI_c_group($i_c_group = null)
    {
        // validation for constraint: int
        if (!is_null($i_c_group) && !is_numeric($i_c_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_c_group)), __LINE__);
        }
        $this->i_c_group = $i_c_group;
        return $this;
    }
    /**
     * Get i_c_ext value
     * @return int|null
     */
    public function getI_c_ext()
    {
        return $this->i_c_ext;
    }
    /**
     * Set i_c_ext value
     * @param int $i_c_ext
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setI_c_ext($i_c_ext = null)
    {
        // validation for constraint: int
        if (!is_null($i_c_ext) && !is_numeric($i_c_ext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_c_ext)), __LINE__);
        }
        $this->i_c_ext = $i_c_ext;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get hunt_sequence value
     * @return string|null
     */
    public function getHunt_sequence()
    {
        return $this->hunt_sequence;
    }
    /**
     * Set hunt_sequence value
     * @param string $hunt_sequence
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setHunt_sequence($hunt_sequence = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_sequence) && !is_string($hunt_sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_sequence)), __LINE__);
        }
        $this->hunt_sequence = $hunt_sequence;
        return $this;
    }
    /**
     * Get add_extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssignedExtensionsInfo[]|null
     */
    public function getAdd_extensions()
    {
        return isset($this->add_extensions) ? $this->add_extensions : null;
    }
    /**
     * Set add_extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo[] $add_extensions
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setAdd_extensions(array $add_extensions = array())
    {
        foreach ($add_extensions as $updateCustomerHuntgroupRequestAdd_extensionsItem) {
            // validation for constraint: itemType
            if (!$updateCustomerHuntgroupRequestAdd_extensionsItem instanceof \StructType\AssignedExtensionsInfo) {
                throw new \InvalidArgumentException(sprintf('The add_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($updateCustomerHuntgroupRequestAdd_extensionsItem) ? get_class($updateCustomerHuntgroupRequestAdd_extensionsItem) : gettype($updateCustomerHuntgroupRequestAdd_extensionsItem)), __LINE__);
            }
        }
        if (is_null($add_extensions) || (is_array($add_extensions) && empty($add_extensions))) {
            unset($this->add_extensions);
        } else {
            $this->add_extensions = $add_extensions;
        }
        return $this;
    }
    /**
     * Add item to add_extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo $item
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function addToAdd_extensions(\StructType\AssignedExtensionsInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedExtensionsInfo) {
            throw new \InvalidArgumentException(sprintf('The add_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->add_extensions[] = $item;
        return $this;
    }
    /**
     * Get del_extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int[]|null
     */
    public function getDel_extensions()
    {
        return isset($this->del_extensions) ? $this->del_extensions : null;
    }
    /**
     * Set del_extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param int[] $del_extensions
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setDel_extensions(array $del_extensions = array())
    {
        foreach ($del_extensions as $updateCustomerHuntgroupRequestDel_extensionsItem) {
            // validation for constraint: itemType
            if (!is_numeric($updateCustomerHuntgroupRequestDel_extensionsItem)) {
                throw new \InvalidArgumentException(sprintf('The del_extensions property can only contain items of int, "%s" given', is_object($updateCustomerHuntgroupRequestDel_extensionsItem) ? get_class($updateCustomerHuntgroupRequestDel_extensionsItem) : gettype($updateCustomerHuntgroupRequestDel_extensionsItem)), __LINE__);
            }
        }
        if (is_null($del_extensions) || (is_array($del_extensions) && empty($del_extensions))) {
            unset($this->del_extensions);
        } else {
            $this->del_extensions = $del_extensions;
        }
        return $this;
    }
    /**
     * Add item to del_extensions value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function addToDel_extensions($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The del_extensions property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->del_extensions[] = $item;
        return $this;
    }
    /**
     * Get chg_extensions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssignedExtensionsInfo[]|null
     */
    public function getChg_extensions()
    {
        return isset($this->chg_extensions) ? $this->chg_extensions : null;
    }
    /**
     * Set chg_extensions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo[] $chg_extensions
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setChg_extensions(array $chg_extensions = array())
    {
        foreach ($chg_extensions as $updateCustomerHuntgroupRequestChg_extensionsItem) {
            // validation for constraint: itemType
            if (!$updateCustomerHuntgroupRequestChg_extensionsItem instanceof \StructType\AssignedExtensionsInfo) {
                throw new \InvalidArgumentException(sprintf('The chg_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($updateCustomerHuntgroupRequestChg_extensionsItem) ? get_class($updateCustomerHuntgroupRequestChg_extensionsItem) : gettype($updateCustomerHuntgroupRequestChg_extensionsItem)), __LINE__);
            }
        }
        if (is_null($chg_extensions) || (is_array($chg_extensions) && empty($chg_extensions))) {
            unset($this->chg_extensions);
        } else {
            $this->chg_extensions = $chg_extensions;
        }
        return $this;
    }
    /**
     * Add item to chg_extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo $item
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function addToChg_extensions(\StructType\AssignedExtensionsInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedExtensionsInfo) {
            throw new \InvalidArgumentException(sprintf('The chg_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->chg_extensions[] = $item;
        return $this;
    }
    /**
     * Get prompt_action value
     * @return string|null
     */
    public function getPrompt_action()
    {
        return $this->prompt_action;
    }
    /**
     * Set prompt_action value
     * @param string $prompt_action
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setPrompt_action($prompt_action = null)
    {
        // validation for constraint: string
        if (!is_null($prompt_action) && !is_string($prompt_action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prompt_action)), __LINE__);
        }
        $this->prompt_action = $prompt_action;
        return $this;
    }
    /**
     * Get pickup_allowed value
     * @return string|null
     */
    public function getPickup_allowed()
    {
        return $this->pickup_allowed;
    }
    /**
     * Set pickup_allowed value
     * @param string $pickup_allowed
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setPickup_allowed($pickup_allowed = null)
    {
        // validation for constraint: string
        if (!is_null($pickup_allowed) && !is_string($pickup_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickup_allowed)), __LINE__);
        }
        $this->pickup_allowed = $pickup_allowed;
        return $this;
    }
    /**
     * Get hunt_keep_original_cli value
     * @return string|null
     */
    public function getHunt_keep_original_cli()
    {
        return $this->hunt_keep_original_cli;
    }
    /**
     * Set hunt_keep_original_cli value
     * @param string $hunt_keep_original_cli
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public function setHunt_keep_original_cli($hunt_keep_original_cli = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_keep_original_cli) && !is_string($hunt_keep_original_cli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_keep_original_cli)), __LINE__);
        }
        $this->hunt_keep_original_cli = $hunt_keep_original_cli;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCustomerHuntgroupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
