<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateCallBarringOptionsRequest StructType
 * @subpackage Structs
 */
class UpdateCallBarringOptionsRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The options
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * - arrayType: pst:CallBarringRuleInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CallBarringRuleInfo[]
     */
    public $options;
    /**
     * Constructor method for UpdateCallBarringOptionsRequest
     * @uses UpdateCallBarringOptionsRequest::setI_account()
     * @uses UpdateCallBarringOptionsRequest::setOptions()
     * @param int $i_account
     * @param \StructType\CallBarringRuleInfo[] $options
     */
    public function __construct($i_account = null, array $options = array())
    {
        $this
            ->setI_account($i_account)
            ->setOptions($options);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\UpdateCallBarringOptionsRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get options value
     * @return \StructType\CallBarringRuleInfo[]
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @throws \InvalidArgumentException
     * @param \StructType\CallBarringRuleInfo[] $options
     * @return \StructType\UpdateCallBarringOptionsRequest
     */
    public function setOptions(array $options = array())
    {
        foreach ($options as $updateCallBarringOptionsRequestOptionsItem) {
            // validation for constraint: itemType
            if (!$updateCallBarringOptionsRequestOptionsItem instanceof \StructType\CallBarringRuleInfo) {
                throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\CallBarringRuleInfo, "%s" given', is_object($updateCallBarringOptionsRequestOptionsItem) ? get_class($updateCallBarringOptionsRequestOptionsItem) : gettype($updateCallBarringOptionsRequestOptionsItem)), __LINE__);
            }
        }
        $this->options = $options;
        return $this;
    }
    /**
     * Add item to options value
     * @throws \InvalidArgumentException
     * @param \StructType\CallBarringRuleInfo $item
     * @return \StructType\UpdateCallBarringOptionsRequest
     */
    public function addToOptions(\StructType\CallBarringRuleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CallBarringRuleInfo) {
            throw new \InvalidArgumentException(sprintf('The options property can only contain items of \StructType\CallBarringRuleInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->options[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateCallBarringOptionsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
