<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAccountServiceFeaturesRequest StructType
 * @subpackage Structs
 */
class UpdateAccountServiceFeaturesRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $i_account;
    /**
     * The service_features
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: pst:ServiceFeatureInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureInfo[]
     */
    public $service_features;
    /**
     * Constructor method for UpdateAccountServiceFeaturesRequest
     * @uses UpdateAccountServiceFeaturesRequest::setI_account()
     * @uses UpdateAccountServiceFeaturesRequest::setService_features()
     * @param int $i_account
     * @param \StructType\ServiceFeatureInfo[] $service_features
     */
    public function __construct($i_account = null, array $service_features = array())
    {
        $this
            ->setI_account($i_account)
            ->setService_features($service_features);
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\UpdateAccountServiceFeaturesRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get service_features value
     * @return \StructType\ServiceFeatureInfo[]|null
     */
    public function getService_features()
    {
        return $this->service_features;
    }
    /**
     * Set service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @return \StructType\UpdateAccountServiceFeaturesRequest
     */
    public function setService_features(array $service_features = array())
    {
        foreach ($service_features as $updateAccountServiceFeaturesRequestService_featuresItem) {
            // validation for constraint: itemType
            if (!$updateAccountServiceFeaturesRequestService_featuresItem instanceof \StructType\ServiceFeatureInfo) {
                throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($updateAccountServiceFeaturesRequestService_featuresItem) ? get_class($updateAccountServiceFeaturesRequestService_featuresItem) : gettype($updateAccountServiceFeaturesRequestService_featuresItem)), __LINE__);
            }
        }
        $this->service_features = $service_features;
        return $this;
    }
    /**
     * Add item to service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo $item
     * @return \StructType\UpdateAccountServiceFeaturesRequest
     */
    public function addToService_features(\StructType\ServiceFeatureInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureInfo) {
            throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_features[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAccountServiceFeaturesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
