<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAccountPaymentMethodRequest StructType
 * @subpackage Structs
 */
class UpdateAccountPaymentMethodRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The payment_method_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaymentMethodInfo
     */
    public $payment_method_info;
    /**
     * Constructor method for UpdateAccountPaymentMethodRequest
     * @uses UpdateAccountPaymentMethodRequest::setI_account()
     * @uses UpdateAccountPaymentMethodRequest::setPayment_method_info()
     * @param int $i_account
     * @param \StructType\PaymentMethodInfo $payment_method_info
     */
    public function __construct($i_account = null, \StructType\PaymentMethodInfo $payment_method_info = null)
    {
        $this
            ->setI_account($i_account)
            ->setPayment_method_info($payment_method_info);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\UpdateAccountPaymentMethodRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get payment_method_info value
     * @return \StructType\PaymentMethodInfo
     */
    public function getPayment_method_info()
    {
        return $this->payment_method_info;
    }
    /**
     * Set payment_method_info value
     * @param \StructType\PaymentMethodInfo $payment_method_info
     * @return \StructType\UpdateAccountPaymentMethodRequest
     */
    public function setPayment_method_info(\StructType\PaymentMethodInfo $payment_method_info = null)
    {
        $this->payment_method_info = $payment_method_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAccountPaymentMethodRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
