<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateAccountCustomFieldsValuesRequest StructType
 * @subpackage Structs
 */
class UpdateAccountCustomFieldsValuesRequest extends AbstractStructBase
{
    /**
     * The custom_fields_values
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:CustomFieldsValuesInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomFieldsValuesInfo[]
     */
    public $custom_fields_values;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * Constructor method for UpdateAccountCustomFieldsValuesRequest
     * @uses UpdateAccountCustomFieldsValuesRequest::setCustom_fields_values()
     * @uses UpdateAccountCustomFieldsValuesRequest::setI_account()
     * @param \StructType\CustomFieldsValuesInfo[] $custom_fields_values
     * @param int $i_account
     */
    public function __construct(array $custom_fields_values = array(), $i_account = null)
    {
        $this
            ->setCustom_fields_values($custom_fields_values)
            ->setI_account($i_account);
    }
    /**
     * Get custom_fields_values value
     * @return \StructType\CustomFieldsValuesInfo[]
     */
    public function getCustom_fields_values()
    {
        return $this->custom_fields_values;
    }
    /**
     * Set custom_fields_values value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsValuesInfo[] $custom_fields_values
     * @return \StructType\UpdateAccountCustomFieldsValuesRequest
     */
    public function setCustom_fields_values(array $custom_fields_values = array())
    {
        foreach ($custom_fields_values as $updateAccountCustomFieldsValuesRequestCustom_fields_valuesItem) {
            // validation for constraint: itemType
            if (!$updateAccountCustomFieldsValuesRequestCustom_fields_valuesItem instanceof \StructType\CustomFieldsValuesInfo) {
                throw new \InvalidArgumentException(sprintf('The custom_fields_values property can only contain items of \StructType\CustomFieldsValuesInfo, "%s" given', is_object($updateAccountCustomFieldsValuesRequestCustom_fields_valuesItem) ? get_class($updateAccountCustomFieldsValuesRequestCustom_fields_valuesItem) : gettype($updateAccountCustomFieldsValuesRequestCustom_fields_valuesItem)), __LINE__);
            }
        }
        $this->custom_fields_values = $custom_fields_values;
        return $this;
    }
    /**
     * Add item to custom_fields_values value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsValuesInfo $item
     * @return \StructType\UpdateAccountCustomFieldsValuesRequest
     */
    public function addToCustom_fields_values(\StructType\CustomFieldsValuesInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldsValuesInfo) {
            throw new \InvalidArgumentException(sprintf('The custom_fields_values property can only contain items of \StructType\CustomFieldsValuesInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->custom_fields_values[] = $item;
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\UpdateAccountCustomFieldsValuesRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateAccountCustomFieldsValuesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
