<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UAInfo StructType
 * @subpackage Structs
 */
class UAInfo extends AbstractStructBase
{
    /**
     * The i_ua
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_ua;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The i_ua_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_ua_type;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The mac
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mac;
    /**
     * The inventory_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inventory_id;
    /**
     * The profile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $profile;
    /**
     * The port
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $port;
    /**
     * The ascii_key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ascii_key;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_customer;
    /**
     * The ua_profile_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ua_profile_id;
    /**
     * The used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $used;
    /**
     * The notepad
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notepad;
    /**
     * The opc_key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $opc_key;
    /**
     * Constructor method for UAInfo
     * @uses UAInfo::setI_ua()
     * @uses UAInfo::setName()
     * @uses UAInfo::setI_ua_type()
     * @uses UAInfo::setType()
     * @uses UAInfo::setDescription()
     * @uses UAInfo::setMac()
     * @uses UAInfo::setInventory_id()
     * @uses UAInfo::setProfile()
     * @uses UAInfo::setPort()
     * @uses UAInfo::setAscii_key()
     * @uses UAInfo::setI_customer()
     * @uses UAInfo::setUa_profile_id()
     * @uses UAInfo::setUsed()
     * @uses UAInfo::setNotepad()
     * @uses UAInfo::setOpc_key()
     * @param int $i_ua
     * @param string $name
     * @param int $i_ua_type
     * @param string $type
     * @param string $description
     * @param string $mac
     * @param string $inventory_id
     * @param string $profile
     * @param string $port
     * @param string $ascii_key
     * @param int $i_customer
     * @param string $ua_profile_id
     * @param string $used
     * @param string $notepad
     * @param string $opc_key
     */
    public function __construct($i_ua = null, $name = null, $i_ua_type = null, $type = null, $description = null, $mac = null, $inventory_id = null, $profile = null, $port = null, $ascii_key = null, $i_customer = null, $ua_profile_id = null, $used = null, $notepad = null, $opc_key = null)
    {
        $this
            ->setI_ua($i_ua)
            ->setName($name)
            ->setI_ua_type($i_ua_type)
            ->setType($type)
            ->setDescription($description)
            ->setMac($mac)
            ->setInventory_id($inventory_id)
            ->setProfile($profile)
            ->setPort($port)
            ->setAscii_key($ascii_key)
            ->setI_customer($i_customer)
            ->setUa_profile_id($ua_profile_id)
            ->setUsed($used)
            ->setNotepad($notepad)
            ->setOpc_key($opc_key);
    }
    /**
     * Get i_ua value
     * @return int
     */
    public function getI_ua()
    {
        return $this->i_ua;
    }
    /**
     * Set i_ua value
     * @param int $i_ua
     * @return \StructType\UAInfo
     */
    public function setI_ua($i_ua = null)
    {
        // validation for constraint: int
        if (!is_null($i_ua) && !is_numeric($i_ua)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_ua)), __LINE__);
        }
        $this->i_ua = $i_ua;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UAInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_ua_type value
     * @return int
     */
    public function getI_ua_type()
    {
        return $this->i_ua_type;
    }
    /**
     * Set i_ua_type value
     * @param int $i_ua_type
     * @return \StructType\UAInfo
     */
    public function setI_ua_type($i_ua_type = null)
    {
        // validation for constraint: int
        if (!is_null($i_ua_type) && !is_numeric($i_ua_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_ua_type)), __LINE__);
        }
        $this->i_ua_type = $i_ua_type;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\UAInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\UAInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get mac value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMac()
    {
        return isset($this->mac) ? $this->mac : null;
    }
    /**
     * Set mac value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mac
     * @return \StructType\UAInfo
     */
    public function setMac($mac = null)
    {
        // validation for constraint: string
        if (!is_null($mac) && !is_string($mac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mac)), __LINE__);
        }
        if (is_null($mac) || (is_array($mac) && empty($mac))) {
            unset($this->mac);
        } else {
            $this->mac = $mac;
        }
        return $this;
    }
    /**
     * Get inventory_id value
     * @return string|null
     */
    public function getInventory_id()
    {
        return $this->inventory_id;
    }
    /**
     * Set inventory_id value
     * @param string $inventory_id
     * @return \StructType\UAInfo
     */
    public function setInventory_id($inventory_id = null)
    {
        // validation for constraint: string
        if (!is_null($inventory_id) && !is_string($inventory_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inventory_id)), __LINE__);
        }
        $this->inventory_id = $inventory_id;
        return $this;
    }
    /**
     * Get profile value
     * @return string|null
     */
    public function getProfile()
    {
        return $this->profile;
    }
    /**
     * Set profile value
     * @param string $profile
     * @return \StructType\UAInfo
     */
    public function setProfile($profile = null)
    {
        // validation for constraint: string
        if (!is_null($profile) && !is_string($profile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profile)), __LINE__);
        }
        $this->profile = $profile;
        return $this;
    }
    /**
     * Get port value
     * @return string|null
     */
    public function getPort()
    {
        return $this->port;
    }
    /**
     * Set port value
     * @param string $port
     * @return \StructType\UAInfo
     */
    public function setPort($port = null)
    {
        // validation for constraint: string
        if (!is_null($port) && !is_string($port)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($port)), __LINE__);
        }
        $this->port = $port;
        return $this;
    }
    /**
     * Get ascii_key value
     * @return string|null
     */
    public function getAscii_key()
    {
        return $this->ascii_key;
    }
    /**
     * Set ascii_key value
     * @param string $ascii_key
     * @return \StructType\UAInfo
     */
    public function setAscii_key($ascii_key = null)
    {
        // validation for constraint: string
        if (!is_null($ascii_key) && !is_string($ascii_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ascii_key)), __LINE__);
        }
        $this->ascii_key = $ascii_key;
        return $this;
    }
    /**
     * Get i_customer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_customer()
    {
        return isset($this->i_customer) ? $this->i_customer : null;
    }
    /**
     * Set i_customer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_customer
     * @return \StructType\UAInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        if (is_null($i_customer) || (is_array($i_customer) && empty($i_customer))) {
            unset($this->i_customer);
        } else {
            $this->i_customer = $i_customer;
        }
        return $this;
    }
    /**
     * Get ua_profile_id value
     * @return string|null
     */
    public function getUa_profile_id()
    {
        return $this->ua_profile_id;
    }
    /**
     * Set ua_profile_id value
     * @param string $ua_profile_id
     * @return \StructType\UAInfo
     */
    public function setUa_profile_id($ua_profile_id = null)
    {
        // validation for constraint: string
        if (!is_null($ua_profile_id) && !is_string($ua_profile_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ua_profile_id)), __LINE__);
        }
        $this->ua_profile_id = $ua_profile_id;
        return $this;
    }
    /**
     * Get used value
     * @return string|null
     */
    public function getUsed()
    {
        return $this->used;
    }
    /**
     * Set used value
     * @param string $used
     * @return \StructType\UAInfo
     */
    public function setUsed($used = null)
    {
        // validation for constraint: string
        if (!is_null($used) && !is_string($used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($used)), __LINE__);
        }
        $this->used = $used;
        return $this;
    }
    /**
     * Get notepad value
     * @return string|null
     */
    public function getNotepad()
    {
        return $this->notepad;
    }
    /**
     * Set notepad value
     * @param string $notepad
     * @return \StructType\UAInfo
     */
    public function setNotepad($notepad = null)
    {
        // validation for constraint: string
        if (!is_null($notepad) && !is_string($notepad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notepad)), __LINE__);
        }
        $this->notepad = $notepad;
        return $this;
    }
    /**
     * Get opc_key value
     * @return string|null
     */
    public function getOpc_key()
    {
        return $this->opc_key;
    }
    /**
     * Set opc_key value
     * @param string $opc_key
     * @return \StructType\UAInfo
     */
    public function setOpc_key($opc_key = null)
    {
        // validation for constraint: string
        if (!is_null($opc_key) && !is_string($opc_key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($opc_key)), __LINE__);
        }
        $this->opc_key = $opc_key;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UAInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
