<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeaturesList StructType
 * @subpackage Structs
 */
class ServiceFeaturesList extends AbstractStructBase
{
    /**
     * The Accounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:ServiceFeatureDetails[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureDetails[]
     */
    public $Accounts;
    /**
     * The Customers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:ServiceFeatureDetails[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureDetails[]
     */
    public $Customers;
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:ServiceFeatureDetails[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureDetails[]
     */
    public $Products;
    /**
     * The CustomerSites
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:ServiceFeatureDetails[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureDetails[]
     */
    public $CustomerSites;
    /**
     * Constructor method for ServiceFeaturesList
     * @uses ServiceFeaturesList::setAccounts()
     * @uses ServiceFeaturesList::setCustomers()
     * @uses ServiceFeaturesList::setProducts()
     * @uses ServiceFeaturesList::setCustomerSites()
     * @param \StructType\ServiceFeatureDetails[] $accounts
     * @param \StructType\ServiceFeatureDetails[] $customers
     * @param \StructType\ServiceFeatureDetails[] $products
     * @param \StructType\ServiceFeatureDetails[] $customerSites
     */
    public function __construct(array $accounts = array(), array $customers = array(), array $products = array(), array $customerSites = array())
    {
        $this
            ->setAccounts($accounts)
            ->setCustomers($customers)
            ->setProducts($products)
            ->setCustomerSites($customerSites);
    }
    /**
     * Get Accounts value
     * @return \StructType\ServiceFeatureDetails[]|null
     */
    public function getAccounts()
    {
        return $this->Accounts;
    }
    /**
     * Set Accounts value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails[] $accounts
     * @return \StructType\ServiceFeaturesList
     */
    public function setAccounts(array $accounts = array())
    {
        foreach ($accounts as $serviceFeaturesListAccountsItem) {
            // validation for constraint: itemType
            if (!$serviceFeaturesListAccountsItem instanceof \StructType\ServiceFeatureDetails) {
                throw new \InvalidArgumentException(sprintf('The Accounts property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($serviceFeaturesListAccountsItem) ? get_class($serviceFeaturesListAccountsItem) : gettype($serviceFeaturesListAccountsItem)), __LINE__);
            }
        }
        $this->Accounts = $accounts;
        return $this;
    }
    /**
     * Add item to Accounts value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails $item
     * @return \StructType\ServiceFeaturesList
     */
    public function addToAccounts(\StructType\ServiceFeatureDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureDetails) {
            throw new \InvalidArgumentException(sprintf('The Accounts property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Accounts[] = $item;
        return $this;
    }
    /**
     * Get Customers value
     * @return \StructType\ServiceFeatureDetails[]|null
     */
    public function getCustomers()
    {
        return $this->Customers;
    }
    /**
     * Set Customers value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails[] $customers
     * @return \StructType\ServiceFeaturesList
     */
    public function setCustomers(array $customers = array())
    {
        foreach ($customers as $serviceFeaturesListCustomersItem) {
            // validation for constraint: itemType
            if (!$serviceFeaturesListCustomersItem instanceof \StructType\ServiceFeatureDetails) {
                throw new \InvalidArgumentException(sprintf('The Customers property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($serviceFeaturesListCustomersItem) ? get_class($serviceFeaturesListCustomersItem) : gettype($serviceFeaturesListCustomersItem)), __LINE__);
            }
        }
        $this->Customers = $customers;
        return $this;
    }
    /**
     * Add item to Customers value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails $item
     * @return \StructType\ServiceFeaturesList
     */
    public function addToCustomers(\StructType\ServiceFeatureDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureDetails) {
            throw new \InvalidArgumentException(sprintf('The Customers property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Customers[] = $item;
        return $this;
    }
    /**
     * Get Products value
     * @return \StructType\ServiceFeatureDetails[]|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails[] $products
     * @return \StructType\ServiceFeaturesList
     */
    public function setProducts(array $products = array())
    {
        foreach ($products as $serviceFeaturesListProductsItem) {
            // validation for constraint: itemType
            if (!$serviceFeaturesListProductsItem instanceof \StructType\ServiceFeatureDetails) {
                throw new \InvalidArgumentException(sprintf('The Products property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($serviceFeaturesListProductsItem) ? get_class($serviceFeaturesListProductsItem) : gettype($serviceFeaturesListProductsItem)), __LINE__);
            }
        }
        $this->Products = $products;
        return $this;
    }
    /**
     * Add item to Products value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails $item
     * @return \StructType\ServiceFeaturesList
     */
    public function addToProducts(\StructType\ServiceFeatureDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureDetails) {
            throw new \InvalidArgumentException(sprintf('The Products property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Products[] = $item;
        return $this;
    }
    /**
     * Get CustomerSites value
     * @return \StructType\ServiceFeatureDetails[]|null
     */
    public function getCustomerSites()
    {
        return $this->CustomerSites;
    }
    /**
     * Set CustomerSites value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails[] $customerSites
     * @return \StructType\ServiceFeaturesList
     */
    public function setCustomerSites(array $customerSites = array())
    {
        foreach ($customerSites as $serviceFeaturesListCustomerSitesItem) {
            // validation for constraint: itemType
            if (!$serviceFeaturesListCustomerSitesItem instanceof \StructType\ServiceFeatureDetails) {
                throw new \InvalidArgumentException(sprintf('The CustomerSites property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($serviceFeaturesListCustomerSitesItem) ? get_class($serviceFeaturesListCustomerSitesItem) : gettype($serviceFeaturesListCustomerSitesItem)), __LINE__);
            }
        }
        $this->CustomerSites = $customerSites;
        return $this;
    }
    /**
     * Add item to CustomerSites value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureDetails $item
     * @return \StructType\ServiceFeaturesList
     */
    public function addToCustomerSites(\StructType\ServiceFeatureDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureDetails) {
            throw new \InvalidArgumentException(sprintf('The CustomerSites property can only contain items of \StructType\ServiceFeatureDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CustomerSites[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceFeaturesList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
