<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeatureInfo StructType
 * @subpackage Structs
 */
class ServiceFeatureInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $name;
    /**
     * The flag_value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: false
     * @var string
     */
    public $flag_value;
    /**
     * The effective_flag_value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var string
     */
    public $effective_flag_value;
    /**
     * The attributes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:ServiceAttributeInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceAttributeInfo[]
     */
    public $attributes;
    /**
     * Constructor method for ServiceFeatureInfo
     * @uses ServiceFeatureInfo::setName()
     * @uses ServiceFeatureInfo::setFlag_value()
     * @uses ServiceFeatureInfo::setEffective_flag_value()
     * @uses ServiceFeatureInfo::setAttributes()
     * @param string $name
     * @param string $flag_value
     * @param string $effective_flag_value
     * @param \StructType\ServiceAttributeInfo[] $attributes
     */
    public function __construct($name = null, $flag_value = null, $effective_flag_value = null, array $attributes = array())
    {
        $this
            ->setName($name)
            ->setFlag_value($flag_value)
            ->setEffective_flag_value($effective_flag_value)
            ->setAttributes($attributes);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ServiceFeatureInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get flag_value value
     * @return string
     */
    public function getFlag_value()
    {
        return $this->flag_value;
    }
    /**
     * Set flag_value value
     * @param string $flag_value
     * @return \StructType\ServiceFeatureInfo
     */
    public function setFlag_value($flag_value = null)
    {
        // validation for constraint: string
        if (!is_null($flag_value) && !is_string($flag_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flag_value)), __LINE__);
        }
        $this->flag_value = $flag_value;
        return $this;
    }
    /**
     * Get effective_flag_value value
     * @return string|null
     */
    public function getEffective_flag_value()
    {
        return $this->effective_flag_value;
    }
    /**
     * Set effective_flag_value value
     * @param string $effective_flag_value
     * @return \StructType\ServiceFeatureInfo
     */
    public function setEffective_flag_value($effective_flag_value = null)
    {
        // validation for constraint: string
        if (!is_null($effective_flag_value) && !is_string($effective_flag_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effective_flag_value)), __LINE__);
        }
        $this->effective_flag_value = $effective_flag_value;
        return $this;
    }
    /**
     * Get attributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceAttributeInfo[]|null
     */
    public function getAttributes()
    {
        return isset($this->attributes) ? $this->attributes : null;
    }
    /**
     * Set attributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceAttributeInfo[] $attributes
     * @return \StructType\ServiceFeatureInfo
     */
    public function setAttributes(array $attributes = array())
    {
        foreach ($attributes as $serviceFeatureInfoAttributesItem) {
            // validation for constraint: itemType
            if (!$serviceFeatureInfoAttributesItem instanceof \StructType\ServiceAttributeInfo) {
                throw new \InvalidArgumentException(sprintf('The attributes property can only contain items of \StructType\ServiceAttributeInfo, "%s" given', is_object($serviceFeatureInfoAttributesItem) ? get_class($serviceFeatureInfoAttributesItem) : gettype($serviceFeatureInfoAttributesItem)), __LINE__);
            }
        }
        if (is_null($attributes) || (is_array($attributes) && empty($attributes))) {
            unset($this->attributes);
        } else {
            $this->attributes = $attributes;
        }
        return $this;
    }
    /**
     * Add item to attributes value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceAttributeInfo $item
     * @return \StructType\ServiceFeatureInfo
     */
    public function addToAttributes(\StructType\ServiceAttributeInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceAttributeInfo) {
            throw new \InvalidArgumentException(sprintf('The attributes property can only contain items of \StructType\ServiceAttributeInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attributes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceFeatureInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
