<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFeatureDetails StructType
 * @subpackage Structs
 */
class ServiceFeatureDetails extends AbstractStructBase
{
    /**
     * The feature_name
     * @var string
     */
    public $feature_name;
    /**
     * The default_flag
     * @var string
     */
    public $default_flag;
    /**
     * The i_service_feature
     * @var int
     */
    public $i_service_feature;
    /**
     * The flag_pos
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $flag_pos;
    /**
     * The attributes_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:ServiceFeatureAttributeDetails[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureAttributeDetails[]
     */
    public $attributes_list;
    /**
     * Constructor method for ServiceFeatureDetails
     * @uses ServiceFeatureDetails::setFeature_name()
     * @uses ServiceFeatureDetails::setDefault_flag()
     * @uses ServiceFeatureDetails::setI_service_feature()
     * @uses ServiceFeatureDetails::setFlag_pos()
     * @uses ServiceFeatureDetails::setAttributes_list()
     * @param string $feature_name
     * @param string $default_flag
     * @param int $i_service_feature
     * @param int $flag_pos
     * @param \StructType\ServiceFeatureAttributeDetails[] $attributes_list
     */
    public function __construct($feature_name = null, $default_flag = null, $i_service_feature = null, $flag_pos = null, array $attributes_list = array())
    {
        $this
            ->setFeature_name($feature_name)
            ->setDefault_flag($default_flag)
            ->setI_service_feature($i_service_feature)
            ->setFlag_pos($flag_pos)
            ->setAttributes_list($attributes_list);
    }
    /**
     * Get feature_name value
     * @return string|null
     */
    public function getFeature_name()
    {
        return $this->feature_name;
    }
    /**
     * Set feature_name value
     * @param string $feature_name
     * @return \StructType\ServiceFeatureDetails
     */
    public function setFeature_name($feature_name = null)
    {
        // validation for constraint: string
        if (!is_null($feature_name) && !is_string($feature_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($feature_name)), __LINE__);
        }
        $this->feature_name = $feature_name;
        return $this;
    }
    /**
     * Get default_flag value
     * @return string|null
     */
    public function getDefault_flag()
    {
        return $this->default_flag;
    }
    /**
     * Set default_flag value
     * @param string $default_flag
     * @return \StructType\ServiceFeatureDetails
     */
    public function setDefault_flag($default_flag = null)
    {
        // validation for constraint: string
        if (!is_null($default_flag) && !is_string($default_flag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_flag)), __LINE__);
        }
        $this->default_flag = $default_flag;
        return $this;
    }
    /**
     * Get i_service_feature value
     * @return int|null
     */
    public function getI_service_feature()
    {
        return $this->i_service_feature;
    }
    /**
     * Set i_service_feature value
     * @param int $i_service_feature
     * @return \StructType\ServiceFeatureDetails
     */
    public function setI_service_feature($i_service_feature = null)
    {
        // validation for constraint: int
        if (!is_null($i_service_feature) && !is_numeric($i_service_feature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service_feature)), __LINE__);
        }
        $this->i_service_feature = $i_service_feature;
        return $this;
    }
    /**
     * Get flag_pos value
     * @return int|null
     */
    public function getFlag_pos()
    {
        return $this->flag_pos;
    }
    /**
     * Set flag_pos value
     * @param int $flag_pos
     * @return \StructType\ServiceFeatureDetails
     */
    public function setFlag_pos($flag_pos = null)
    {
        // validation for constraint: int
        if (!is_null($flag_pos) && !is_numeric($flag_pos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flag_pos)), __LINE__);
        }
        $this->flag_pos = $flag_pos;
        return $this;
    }
    /**
     * Get attributes_list value
     * @return \StructType\ServiceFeatureAttributeDetails[]|null
     */
    public function getAttributes_list()
    {
        return $this->attributes_list;
    }
    /**
     * Set attributes_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureAttributeDetails[] $attributes_list
     * @return \StructType\ServiceFeatureDetails
     */
    public function setAttributes_list(array $attributes_list = array())
    {
        foreach ($attributes_list as $serviceFeatureDetailsAttributes_listItem) {
            // validation for constraint: itemType
            if (!$serviceFeatureDetailsAttributes_listItem instanceof \StructType\ServiceFeatureAttributeDetails) {
                throw new \InvalidArgumentException(sprintf('The attributes_list property can only contain items of \StructType\ServiceFeatureAttributeDetails, "%s" given', is_object($serviceFeatureDetailsAttributes_listItem) ? get_class($serviceFeatureDetailsAttributes_listItem) : gettype($serviceFeatureDetailsAttributes_listItem)), __LINE__);
            }
        }
        $this->attributes_list = $attributes_list;
        return $this;
    }
    /**
     * Add item to attributes_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureAttributeDetails $item
     * @return \StructType\ServiceFeatureDetails
     */
    public function addToAttributes_list(\StructType\ServiceFeatureAttributeDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureAttributeDetails) {
            throw new \InvalidArgumentException(sprintf('The attributes_list property can only contain items of \StructType\ServiceFeatureAttributeDetails, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attributes_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ServiceFeatureDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
