<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteInfo StructType
 * @subpackage Structs
 */
class RouteInfo extends AbstractStructBase
{
    /**
     * The appcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appcode;
    /**
     * The cld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cld;
    /**
     * The t_cld
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $t_cld;
    /**
     * The cost
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $cost;
    /**
     * The huntstop
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $huntstop;
    /**
     * The preference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $preference;
    /**
     * The route_category_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $route_category_name;
    /**
     * The currency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The destination_country
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination_country;
    /**
     * The destination_description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $destination_description;
    /**
     * The h323
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $h323;
    /**
     * The sip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sip;
    /**
     * The i_connection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_connection;
    /**
     * The i_rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_rate;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_tariff;
    /**
     * The i_vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_vendor;
    /**
     * The i_route_category
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_route_category;
    /**
     * The node_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $node_name;
    /**
     * The connection_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $connection_name;
    /**
     * The penalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $penalty;
    /**
     * The remote_ip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $remote_ip;
    /**
     * The tariff_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tariff_name;
    /**
     * The tech_prefix
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tech_prefix;
    /**
     * The translation_rule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $translation_rule;
    /**
     * The vendor_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendor_name;
    /**
     * Constructor method for RouteInfo
     * @uses RouteInfo::setAppcode()
     * @uses RouteInfo::setCld()
     * @uses RouteInfo::setT_cld()
     * @uses RouteInfo::setCost()
     * @uses RouteInfo::setHuntstop()
     * @uses RouteInfo::setPreference()
     * @uses RouteInfo::setRoute_category_name()
     * @uses RouteInfo::setCurrency()
     * @uses RouteInfo::setDestination()
     * @uses RouteInfo::setDestination_country()
     * @uses RouteInfo::setDestination_description()
     * @uses RouteInfo::setH323()
     * @uses RouteInfo::setSip()
     * @uses RouteInfo::setI_connection()
     * @uses RouteInfo::setI_rate()
     * @uses RouteInfo::setI_tariff()
     * @uses RouteInfo::setI_vendor()
     * @uses RouteInfo::setI_route_category()
     * @uses RouteInfo::setNode_name()
     * @uses RouteInfo::setConnection_name()
     * @uses RouteInfo::setPenalty()
     * @uses RouteInfo::setRemote_ip()
     * @uses RouteInfo::setTariff_name()
     * @uses RouteInfo::setTech_prefix()
     * @uses RouteInfo::setTranslation_rule()
     * @uses RouteInfo::setVendor_name()
     * @param string $appcode
     * @param string $cld
     * @param string $t_cld
     * @param float $cost
     * @param string $huntstop
     * @param int $preference
     * @param string $route_category_name
     * @param string $currency
     * @param string $destination
     * @param string $destination_country
     * @param string $destination_description
     * @param string $h323
     * @param string $sip
     * @param int $i_connection
     * @param int $i_rate
     * @param int $i_tariff
     * @param int $i_vendor
     * @param int $i_route_category
     * @param string $node_name
     * @param string $connection_name
     * @param string $penalty
     * @param string $remote_ip
     * @param string $tariff_name
     * @param string $tech_prefix
     * @param string $translation_rule
     * @param string $vendor_name
     */
    public function __construct($appcode = null, $cld = null, $t_cld = null, $cost = null, $huntstop = null, $preference = null, $route_category_name = null, $currency = null, $destination = null, $destination_country = null, $destination_description = null, $h323 = null, $sip = null, $i_connection = null, $i_rate = null, $i_tariff = null, $i_vendor = null, $i_route_category = null, $node_name = null, $connection_name = null, $penalty = null, $remote_ip = null, $tariff_name = null, $tech_prefix = null, $translation_rule = null, $vendor_name = null)
    {
        $this
            ->setAppcode($appcode)
            ->setCld($cld)
            ->setT_cld($t_cld)
            ->setCost($cost)
            ->setHuntstop($huntstop)
            ->setPreference($preference)
            ->setRoute_category_name($route_category_name)
            ->setCurrency($currency)
            ->setDestination($destination)
            ->setDestination_country($destination_country)
            ->setDestination_description($destination_description)
            ->setH323($h323)
            ->setSip($sip)
            ->setI_connection($i_connection)
            ->setI_rate($i_rate)
            ->setI_tariff($i_tariff)
            ->setI_vendor($i_vendor)
            ->setI_route_category($i_route_category)
            ->setNode_name($node_name)
            ->setConnection_name($connection_name)
            ->setPenalty($penalty)
            ->setRemote_ip($remote_ip)
            ->setTariff_name($tariff_name)
            ->setTech_prefix($tech_prefix)
            ->setTranslation_rule($translation_rule)
            ->setVendor_name($vendor_name);
    }
    /**
     * Get appcode value
     * @return string|null
     */
    public function getAppcode()
    {
        return $this->appcode;
    }
    /**
     * Set appcode value
     * @param string $appcode
     * @return \StructType\RouteInfo
     */
    public function setAppcode($appcode = null)
    {
        // validation for constraint: string
        if (!is_null($appcode) && !is_string($appcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($appcode)), __LINE__);
        }
        $this->appcode = $appcode;
        return $this;
    }
    /**
     * Get cld value
     * @return string|null
     */
    public function getCld()
    {
        return $this->cld;
    }
    /**
     * Set cld value
     * @param string $cld
     * @return \StructType\RouteInfo
     */
    public function setCld($cld = null)
    {
        // validation for constraint: string
        if (!is_null($cld) && !is_string($cld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cld)), __LINE__);
        }
        $this->cld = $cld;
        return $this;
    }
    /**
     * Get t_cld value
     * @return string|null
     */
    public function getT_cld()
    {
        return $this->t_cld;
    }
    /**
     * Set t_cld value
     * @param string $t_cld
     * @return \StructType\RouteInfo
     */
    public function setT_cld($t_cld = null)
    {
        // validation for constraint: string
        if (!is_null($t_cld) && !is_string($t_cld)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($t_cld)), __LINE__);
        }
        $this->t_cld = $t_cld;
        return $this;
    }
    /**
     * Get cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->cost;
    }
    /**
     * Set cost value
     * @param float $cost
     * @return \StructType\RouteInfo
     */
    public function setCost($cost = null)
    {
        $this->cost = $cost;
        return $this;
    }
    /**
     * Get huntstop value
     * @return string|null
     */
    public function getHuntstop()
    {
        return $this->huntstop;
    }
    /**
     * Set huntstop value
     * @param string $huntstop
     * @return \StructType\RouteInfo
     */
    public function setHuntstop($huntstop = null)
    {
        // validation for constraint: string
        if (!is_null($huntstop) && !is_string($huntstop)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($huntstop)), __LINE__);
        }
        $this->huntstop = $huntstop;
        return $this;
    }
    /**
     * Get preference value
     * @return int|null
     */
    public function getPreference()
    {
        return $this->preference;
    }
    /**
     * Set preference value
     * @param int $preference
     * @return \StructType\RouteInfo
     */
    public function setPreference($preference = null)
    {
        // validation for constraint: int
        if (!is_null($preference) && !is_numeric($preference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($preference)), __LINE__);
        }
        $this->preference = $preference;
        return $this;
    }
    /**
     * Get route_category_name value
     * @return string|null
     */
    public function getRoute_category_name()
    {
        return $this->route_category_name;
    }
    /**
     * Set route_category_name value
     * @param string $route_category_name
     * @return \StructType\RouteInfo
     */
    public function setRoute_category_name($route_category_name = null)
    {
        // validation for constraint: string
        if (!is_null($route_category_name) && !is_string($route_category_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($route_category_name)), __LINE__);
        }
        $this->route_category_name = $route_category_name;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\RouteInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\RouteInfo
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get destination_country value
     * @return string|null
     */
    public function getDestination_country()
    {
        return $this->destination_country;
    }
    /**
     * Set destination_country value
     * @param string $destination_country
     * @return \StructType\RouteInfo
     */
    public function setDestination_country($destination_country = null)
    {
        // validation for constraint: string
        if (!is_null($destination_country) && !is_string($destination_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination_country)), __LINE__);
        }
        $this->destination_country = $destination_country;
        return $this;
    }
    /**
     * Get destination_description value
     * @return string|null
     */
    public function getDestination_description()
    {
        return $this->destination_description;
    }
    /**
     * Set destination_description value
     * @param string $destination_description
     * @return \StructType\RouteInfo
     */
    public function setDestination_description($destination_description = null)
    {
        // validation for constraint: string
        if (!is_null($destination_description) && !is_string($destination_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination_description)), __LINE__);
        }
        $this->destination_description = $destination_description;
        return $this;
    }
    /**
     * Get h323 value
     * @return string|null
     */
    public function getH323()
    {
        return $this->h323;
    }
    /**
     * Set h323 value
     * @param string $h323
     * @return \StructType\RouteInfo
     */
    public function setH323($h323 = null)
    {
        // validation for constraint: string
        if (!is_null($h323) && !is_string($h323)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323)), __LINE__);
        }
        $this->h323 = $h323;
        return $this;
    }
    /**
     * Get sip value
     * @return string|null
     */
    public function getSip()
    {
        return $this->sip;
    }
    /**
     * Set sip value
     * @param string $sip
     * @return \StructType\RouteInfo
     */
    public function setSip($sip = null)
    {
        // validation for constraint: string
        if (!is_null($sip) && !is_string($sip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sip)), __LINE__);
        }
        $this->sip = $sip;
        return $this;
    }
    /**
     * Get i_connection value
     * @return int|null
     */
    public function getI_connection()
    {
        return $this->i_connection;
    }
    /**
     * Set i_connection value
     * @param int $i_connection
     * @return \StructType\RouteInfo
     */
    public function setI_connection($i_connection = null)
    {
        // validation for constraint: int
        if (!is_null($i_connection) && !is_numeric($i_connection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_connection)), __LINE__);
        }
        $this->i_connection = $i_connection;
        return $this;
    }
    /**
     * Get i_rate value
     * @return int|null
     */
    public function getI_rate()
    {
        return $this->i_rate;
    }
    /**
     * Set i_rate value
     * @param int $i_rate
     * @return \StructType\RouteInfo
     */
    public function setI_rate($i_rate = null)
    {
        // validation for constraint: int
        if (!is_null($i_rate) && !is_numeric($i_rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_rate)), __LINE__);
        }
        $this->i_rate = $i_rate;
        return $this;
    }
    /**
     * Get i_tariff value
     * @return int|null
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\RouteInfo
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get i_vendor value
     * @return int|null
     */
    public function getI_vendor()
    {
        return $this->i_vendor;
    }
    /**
     * Set i_vendor value
     * @param int $i_vendor
     * @return \StructType\RouteInfo
     */
    public function setI_vendor($i_vendor = null)
    {
        // validation for constraint: int
        if (!is_null($i_vendor) && !is_numeric($i_vendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vendor)), __LINE__);
        }
        $this->i_vendor = $i_vendor;
        return $this;
    }
    /**
     * Get i_route_category value
     * @return int|null
     */
    public function getI_route_category()
    {
        return $this->i_route_category;
    }
    /**
     * Set i_route_category value
     * @param int $i_route_category
     * @return \StructType\RouteInfo
     */
    public function setI_route_category($i_route_category = null)
    {
        // validation for constraint: int
        if (!is_null($i_route_category) && !is_numeric($i_route_category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_route_category)), __LINE__);
        }
        $this->i_route_category = $i_route_category;
        return $this;
    }
    /**
     * Get node_name value
     * @return string|null
     */
    public function getNode_name()
    {
        return $this->node_name;
    }
    /**
     * Set node_name value
     * @param string $node_name
     * @return \StructType\RouteInfo
     */
    public function setNode_name($node_name = null)
    {
        // validation for constraint: string
        if (!is_null($node_name) && !is_string($node_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($node_name)), __LINE__);
        }
        $this->node_name = $node_name;
        return $this;
    }
    /**
     * Get connection_name value
     * @return string|null
     */
    public function getConnection_name()
    {
        return $this->connection_name;
    }
    /**
     * Set connection_name value
     * @param string $connection_name
     * @return \StructType\RouteInfo
     */
    public function setConnection_name($connection_name = null)
    {
        // validation for constraint: string
        if (!is_null($connection_name) && !is_string($connection_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($connection_name)), __LINE__);
        }
        $this->connection_name = $connection_name;
        return $this;
    }
    /**
     * Get penalty value
     * @return string|null
     */
    public function getPenalty()
    {
        return $this->penalty;
    }
    /**
     * Set penalty value
     * @param string $penalty
     * @return \StructType\RouteInfo
     */
    public function setPenalty($penalty = null)
    {
        // validation for constraint: string
        if (!is_null($penalty) && !is_string($penalty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($penalty)), __LINE__);
        }
        $this->penalty = $penalty;
        return $this;
    }
    /**
     * Get remote_ip value
     * @return string|null
     */
    public function getRemote_ip()
    {
        return $this->remote_ip;
    }
    /**
     * Set remote_ip value
     * @param string $remote_ip
     * @return \StructType\RouteInfo
     */
    public function setRemote_ip($remote_ip = null)
    {
        // validation for constraint: string
        if (!is_null($remote_ip) && !is_string($remote_ip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($remote_ip)), __LINE__);
        }
        $this->remote_ip = $remote_ip;
        return $this;
    }
    /**
     * Get tariff_name value
     * @return string|null
     */
    public function getTariff_name()
    {
        return $this->tariff_name;
    }
    /**
     * Set tariff_name value
     * @param string $tariff_name
     * @return \StructType\RouteInfo
     */
    public function setTariff_name($tariff_name = null)
    {
        // validation for constraint: string
        if (!is_null($tariff_name) && !is_string($tariff_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariff_name)), __LINE__);
        }
        $this->tariff_name = $tariff_name;
        return $this;
    }
    /**
     * Get tech_prefix value
     * @return string|null
     */
    public function getTech_prefix()
    {
        return $this->tech_prefix;
    }
    /**
     * Set tech_prefix value
     * @param string $tech_prefix
     * @return \StructType\RouteInfo
     */
    public function setTech_prefix($tech_prefix = null)
    {
        // validation for constraint: string
        if (!is_null($tech_prefix) && !is_string($tech_prefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tech_prefix)), __LINE__);
        }
        $this->tech_prefix = $tech_prefix;
        return $this;
    }
    /**
     * Get translation_rule value
     * @return string|null
     */
    public function getTranslation_rule()
    {
        return $this->translation_rule;
    }
    /**
     * Set translation_rule value
     * @param string $translation_rule
     * @return \StructType\RouteInfo
     */
    public function setTranslation_rule($translation_rule = null)
    {
        // validation for constraint: string
        if (!is_null($translation_rule) && !is_string($translation_rule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($translation_rule)), __LINE__);
        }
        $this->translation_rule = $translation_rule;
        return $this;
    }
    /**
     * Get vendor_name value
     * @return string|null
     */
    public function getVendor_name()
    {
        return $this->vendor_name;
    }
    /**
     * Set vendor_name value
     * @param string $vendor_name
     * @return \StructType\RouteInfo
     */
    public function setVendor_name($vendor_name = null)
    {
        // validation for constraint: string
        if (!is_null($vendor_name) && !is_string($vendor_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendor_name)), __LINE__);
        }
        $this->vendor_name = $vendor_name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RouteInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
