<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ObjectPermissions StructType
 * @subpackage Structs
 */
class ObjectPermissions extends AbstractStructBase
{
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $object;
    /**
     * The attributes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - arrayType: pst:AttributePermission[]
     * - ref: soapenc:arrayType
     * @var \StructType\AttributePermission[]
     */
    public $attributes;
    /**
     * Constructor method for ObjectPermissions
     * @uses ObjectPermissions::setObject()
     * @uses ObjectPermissions::setAttributes()
     * @param string $object
     * @param \StructType\AttributePermission[] $attributes
     */
    public function __construct($object = null, array $attributes = array())
    {
        $this
            ->setObject($object)
            ->setAttributes($attributes);
    }
    /**
     * Get object value
     * @return string
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\ObjectPermissions
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get attributes value
     * @return \StructType\AttributePermission[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }
    /**
     * Set attributes value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributePermission[] $attributes
     * @return \StructType\ObjectPermissions
     */
    public function setAttributes(array $attributes = array())
    {
        foreach ($attributes as $objectPermissionsAttributesItem) {
            // validation for constraint: itemType
            if (!$objectPermissionsAttributesItem instanceof \StructType\AttributePermission) {
                throw new \InvalidArgumentException(sprintf('The attributes property can only contain items of \StructType\AttributePermission, "%s" given', is_object($objectPermissionsAttributesItem) ? get_class($objectPermissionsAttributesItem) : gettype($objectPermissionsAttributesItem)), __LINE__);
            }
        }
        $this->attributes = $attributes;
        return $this;
    }
    /**
     * Add item to attributes value
     * @throws \InvalidArgumentException
     * @param \StructType\AttributePermission $item
     * @return \StructType\ObjectPermissions
     */
    public function addToAttributes(\StructType\AttributePermission $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AttributePermission) {
            throw new \InvalidArgumentException(sprintf('The attributes property can only contain items of \StructType\AttributePermission, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->attributes[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ObjectPermissions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
