<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkConnectivityInfo StructType
 * @subpackage Structs
 */
class NetworkConnectivityInfo extends AbstractStructBase
{
    /**
     * The i_network_connectivity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_network_connectivity;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The i_env
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_env;
    /**
     * The mtu
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $mtu;
    /**
     * The overhead_bits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $overhead_bits;
    /**
     * Constructor method for NetworkConnectivityInfo
     * @uses NetworkConnectivityInfo::setI_network_connectivity()
     * @uses NetworkConnectivityInfo::setName()
     * @uses NetworkConnectivityInfo::setI_env()
     * @uses NetworkConnectivityInfo::setMtu()
     * @uses NetworkConnectivityInfo::setOverhead_bits()
     * @param int $i_network_connectivity
     * @param string $name
     * @param int $i_env
     * @param int $mtu
     * @param int $overhead_bits
     */
    public function __construct($i_network_connectivity = null, $name = null, $i_env = null, $mtu = null, $overhead_bits = null)
    {
        $this
            ->setI_network_connectivity($i_network_connectivity)
            ->setName($name)
            ->setI_env($i_env)
            ->setMtu($mtu)
            ->setOverhead_bits($overhead_bits);
    }
    /**
     * Get i_network_connectivity value
     * @return int
     */
    public function getI_network_connectivity()
    {
        return $this->i_network_connectivity;
    }
    /**
     * Set i_network_connectivity value
     * @param int $i_network_connectivity
     * @return \StructType\NetworkConnectivityInfo
     */
    public function setI_network_connectivity($i_network_connectivity = null)
    {
        // validation for constraint: int
        if (!is_null($i_network_connectivity) && !is_numeric($i_network_connectivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_network_connectivity)), __LINE__);
        }
        $this->i_network_connectivity = $i_network_connectivity;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\NetworkConnectivityInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_env value
     * @return int|null
     */
    public function getI_env()
    {
        return $this->i_env;
    }
    /**
     * Set i_env value
     * @param int $i_env
     * @return \StructType\NetworkConnectivityInfo
     */
    public function setI_env($i_env = null)
    {
        // validation for constraint: int
        if (!is_null($i_env) && !is_numeric($i_env)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_env)), __LINE__);
        }
        $this->i_env = $i_env;
        return $this;
    }
    /**
     * Get mtu value
     * @return int|null
     */
    public function getMtu()
    {
        return $this->mtu;
    }
    /**
     * Set mtu value
     * @param int $mtu
     * @return \StructType\NetworkConnectivityInfo
     */
    public function setMtu($mtu = null)
    {
        // validation for constraint: int
        if (!is_null($mtu) && !is_numeric($mtu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mtu)), __LINE__);
        }
        $this->mtu = $mtu;
        return $this;
    }
    /**
     * Get overhead_bits value
     * @return int|null
     */
    public function getOverhead_bits()
    {
        return $this->overhead_bits;
    }
    /**
     * Set overhead_bits value
     * @param int $overhead_bits
     * @return \StructType\NetworkConnectivityInfo
     */
    public function setOverhead_bits($overhead_bits = null)
    {
        // validation for constraint: int
        if (!is_null($overhead_bits) && !is_numeric($overhead_bits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($overhead_bits)), __LINE__);
        }
        $this->overhead_bits = $overhead_bits;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NetworkConnectivityInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
