<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeCustomerTransactionResponse StructType
 * @subpackage Structs
 */
class MakeCustomerTransactionResponse extends AbstractStructBase
{
    /**
     * The balance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $balance;
    /**
     * The i_payment_transaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_payment_transaction;
    /**
     * The transaction_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transaction_id;
    /**
     * The authorization
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $authorization;
    /**
     * The result_code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $result_code;
    /**
     * The i_xdr
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_xdr;
    /**
     * Constructor method for MakeCustomerTransactionResponse
     * @uses MakeCustomerTransactionResponse::setBalance()
     * @uses MakeCustomerTransactionResponse::setI_payment_transaction()
     * @uses MakeCustomerTransactionResponse::setTransaction_id()
     * @uses MakeCustomerTransactionResponse::setAuthorization()
     * @uses MakeCustomerTransactionResponse::setResult_code()
     * @uses MakeCustomerTransactionResponse::setI_xdr()
     * @param float $balance
     * @param int $i_payment_transaction
     * @param string $transaction_id
     * @param string $authorization
     * @param string $result_code
     * @param int $i_xdr
     */
    public function __construct($balance = null, $i_payment_transaction = null, $transaction_id = null, $authorization = null, $result_code = null, $i_xdr = null)
    {
        $this
            ->setBalance($balance)
            ->setI_payment_transaction($i_payment_transaction)
            ->setTransaction_id($transaction_id)
            ->setAuthorization($authorization)
            ->setResult_code($result_code)
            ->setI_xdr($i_xdr);
    }
    /**
     * Get balance value
     * @return float
     */
    public function getBalance()
    {
        return $this->balance;
    }
    /**
     * Set balance value
     * @param float $balance
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public function setBalance($balance = null)
    {
        $this->balance = $balance;
        return $this;
    }
    /**
     * Get i_payment_transaction value
     * @return int|null
     */
    public function getI_payment_transaction()
    {
        return $this->i_payment_transaction;
    }
    /**
     * Set i_payment_transaction value
     * @param int $i_payment_transaction
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public function setI_payment_transaction($i_payment_transaction = null)
    {
        // validation for constraint: int
        if (!is_null($i_payment_transaction) && !is_numeric($i_payment_transaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_payment_transaction)), __LINE__);
        }
        $this->i_payment_transaction = $i_payment_transaction;
        return $this;
    }
    /**
     * Get transaction_id value
     * @return string|null
     */
    public function getTransaction_id()
    {
        return $this->transaction_id;
    }
    /**
     * Set transaction_id value
     * @param string $transaction_id
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public function setTransaction_id($transaction_id = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_id) && !is_string($transaction_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transaction_id)), __LINE__);
        }
        $this->transaction_id = $transaction_id;
        return $this;
    }
    /**
     * Get authorization value
     * @return string|null
     */
    public function getAuthorization()
    {
        return $this->authorization;
    }
    /**
     * Set authorization value
     * @param string $authorization
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public function setAuthorization($authorization = null)
    {
        // validation for constraint: string
        if (!is_null($authorization) && !is_string($authorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorization)), __LINE__);
        }
        $this->authorization = $authorization;
        return $this;
    }
    /**
     * Get result_code value
     * @return string|null
     */
    public function getResult_code()
    {
        return $this->result_code;
    }
    /**
     * Set result_code value
     * @param string $result_code
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public function setResult_code($result_code = null)
    {
        // validation for constraint: string
        if (!is_null($result_code) && !is_string($result_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($result_code)), __LINE__);
        }
        $this->result_code = $result_code;
        return $this;
    }
    /**
     * Get i_xdr value
     * @return int|null
     */
    public function getI_xdr()
    {
        return $this->i_xdr;
    }
    /**
     * Set i_xdr value
     * @param int $i_xdr
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public function setI_xdr($i_xdr = null)
    {
        // validation for constraint: int
        if (!is_null($i_xdr) && !is_numeric($i_xdr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_xdr)), __LINE__);
        }
        $this->i_xdr = $i_xdr;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeCustomerTransactionResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
