<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeAccountTransactionRequest StructType
 * @subpackage Structs
 */
class MakeAccountTransactionRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The action
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $action;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $amount;
    /**
     * The visible_comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $visible_comment;
    /**
     * The internal_comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $internal_comment;
    /**
     * The suppress_notification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $suppress_notification;
    /**
     * The transaction_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transaction_id;
    /**
     * The h323_conf_id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $h323_conf_id;
    /**
     * The card_info
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaymentMethodInfo
     */
    public $card_info;
    /**
     * The save_card
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $save_card;
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service;
    /**
     * The date_inside_billing_period
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $date_inside_billing_period;
    /**
     * Constructor method for MakeAccountTransactionRequest
     * @uses MakeAccountTransactionRequest::setI_account()
     * @uses MakeAccountTransactionRequest::setAction()
     * @uses MakeAccountTransactionRequest::setAmount()
     * @uses MakeAccountTransactionRequest::setVisible_comment()
     * @uses MakeAccountTransactionRequest::setInternal_comment()
     * @uses MakeAccountTransactionRequest::setSuppress_notification()
     * @uses MakeAccountTransactionRequest::setTransaction_id()
     * @uses MakeAccountTransactionRequest::setH323_conf_id()
     * @uses MakeAccountTransactionRequest::setCard_info()
     * @uses MakeAccountTransactionRequest::setSave_card()
     * @uses MakeAccountTransactionRequest::setI_service()
     * @uses MakeAccountTransactionRequest::setDate_inside_billing_period()
     * @param int $i_account
     * @param string $action
     * @param float $amount
     * @param string $visible_comment
     * @param string $internal_comment
     * @param int $suppress_notification
     * @param string $transaction_id
     * @param string $h323_conf_id
     * @param \StructType\PaymentMethodInfo $card_info
     * @param string $save_card
     * @param int $i_service
     * @param string $date_inside_billing_period
     */
    public function __construct($i_account = null, $action = null, $amount = null, $visible_comment = null, $internal_comment = null, $suppress_notification = null, $transaction_id = null, $h323_conf_id = null, \StructType\PaymentMethodInfo $card_info = null, $save_card = null, $i_service = null, $date_inside_billing_period = null)
    {
        $this
            ->setI_account($i_account)
            ->setAction($action)
            ->setAmount($amount)
            ->setVisible_comment($visible_comment)
            ->setInternal_comment($internal_comment)
            ->setSuppress_notification($suppress_notification)
            ->setTransaction_id($transaction_id)
            ->setH323_conf_id($h323_conf_id)
            ->setCard_info($card_info)
            ->setSave_card($save_card)
            ->setI_service($i_service)
            ->setDate_inside_billing_period($date_inside_billing_period);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get action value
     * @return string
     */
    public function getAction()
    {
        return $this->action;
    }
    /**
     * Set action value
     * @param string $action
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: string
        if (!is_null($action) && !is_string($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($action)), __LINE__);
        }
        $this->action = $action;
        return $this;
    }
    /**
     * Get amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get visible_comment value
     * @return string|null
     */
    public function getVisible_comment()
    {
        return $this->visible_comment;
    }
    /**
     * Set visible_comment value
     * @param string $visible_comment
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setVisible_comment($visible_comment = null)
    {
        // validation for constraint: string
        if (!is_null($visible_comment) && !is_string($visible_comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($visible_comment)), __LINE__);
        }
        $this->visible_comment = $visible_comment;
        return $this;
    }
    /**
     * Get internal_comment value
     * @return string|null
     */
    public function getInternal_comment()
    {
        return $this->internal_comment;
    }
    /**
     * Set internal_comment value
     * @param string $internal_comment
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setInternal_comment($internal_comment = null)
    {
        // validation for constraint: string
        if (!is_null($internal_comment) && !is_string($internal_comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internal_comment)), __LINE__);
        }
        $this->internal_comment = $internal_comment;
        return $this;
    }
    /**
     * Get suppress_notification value
     * @return int|null
     */
    public function getSuppress_notification()
    {
        return $this->suppress_notification;
    }
    /**
     * Set suppress_notification value
     * @param int $suppress_notification
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setSuppress_notification($suppress_notification = null)
    {
        // validation for constraint: int
        if (!is_null($suppress_notification) && !is_numeric($suppress_notification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suppress_notification)), __LINE__);
        }
        $this->suppress_notification = $suppress_notification;
        return $this;
    }
    /**
     * Get transaction_id value
     * @return string|null
     */
    public function getTransaction_id()
    {
        return $this->transaction_id;
    }
    /**
     * Set transaction_id value
     * @param string $transaction_id
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setTransaction_id($transaction_id = null)
    {
        // validation for constraint: string
        if (!is_null($transaction_id) && !is_string($transaction_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transaction_id)), __LINE__);
        }
        $this->transaction_id = $transaction_id;
        return $this;
    }
    /**
     * Get h323_conf_id value
     * @return string|null
     */
    public function getH323_conf_id()
    {
        return $this->h323_conf_id;
    }
    /**
     * Set h323_conf_id value
     * @param string $h323_conf_id
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setH323_conf_id($h323_conf_id = null)
    {
        // validation for constraint: string
        if (!is_null($h323_conf_id) && !is_string($h323_conf_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($h323_conf_id)), __LINE__);
        }
        $this->h323_conf_id = $h323_conf_id;
        return $this;
    }
    /**
     * Get card_info value
     * @return \StructType\PaymentMethodInfo|null
     */
    public function getCard_info()
    {
        return $this->card_info;
    }
    /**
     * Set card_info value
     * @param \StructType\PaymentMethodInfo $card_info
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setCard_info(\StructType\PaymentMethodInfo $card_info = null)
    {
        $this->card_info = $card_info;
        return $this;
    }
    /**
     * Get save_card value
     * @return string|null
     */
    public function getSave_card()
    {
        return $this->save_card;
    }
    /**
     * Set save_card value
     * @param string $save_card
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setSave_card($save_card = null)
    {
        // validation for constraint: string
        if (!is_null($save_card) && !is_string($save_card)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($save_card)), __LINE__);
        }
        $this->save_card = $save_card;
        return $this;
    }
    /**
     * Get i_service value
     * @return int|null
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get date_inside_billing_period value
     * @return string|null
     */
    public function getDate_inside_billing_period()
    {
        return $this->date_inside_billing_period;
    }
    /**
     * Set date_inside_billing_period value
     * @param string $date_inside_billing_period
     * @return \StructType\MakeAccountTransactionRequest
     */
    public function setDate_inside_billing_period($date_inside_billing_period = null)
    {
        // validation for constraint: string
        if (!is_null($date_inside_billing_period) && !is_string($date_inside_billing_period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_inside_billing_period)), __LINE__);
        }
        $this->date_inside_billing_period = $date_inside_billing_period;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeAccountTransactionRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
