<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MOHListInfo StructType
 * @subpackage Structs
 */
class MOHListInfo extends AbstractStructBase
{
    /**
     * The system_default_i_moh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $system_default_i_moh;
    /**
     * The is_moh_update_disabled
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_moh_update_disabled;
    /**
     * The default_moh_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:MOHInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\MOHInfo[]
     */
    public $default_moh_list;
    /**
     * The customer_defined_moh_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:MOHInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\MOHInfo[]
     */
    public $customer_defined_moh_list;
    /**
     * The aggregated_moh_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:MOHInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\MOHInfo[]
     */
    public $aggregated_moh_list;
    /**
     * Constructor method for MOHListInfo
     * @uses MOHListInfo::setSystem_default_i_moh()
     * @uses MOHListInfo::setIs_moh_update_disabled()
     * @uses MOHListInfo::setDefault_moh_list()
     * @uses MOHListInfo::setCustomer_defined_moh_list()
     * @uses MOHListInfo::setAggregated_moh_list()
     * @param int $system_default_i_moh
     * @param int $is_moh_update_disabled
     * @param \StructType\MOHInfo[] $default_moh_list
     * @param \StructType\MOHInfo[] $customer_defined_moh_list
     * @param \StructType\MOHInfo[] $aggregated_moh_list
     */
    public function __construct($system_default_i_moh = null, $is_moh_update_disabled = null, array $default_moh_list = array(), array $customer_defined_moh_list = array(), array $aggregated_moh_list = array())
    {
        $this
            ->setSystem_default_i_moh($system_default_i_moh)
            ->setIs_moh_update_disabled($is_moh_update_disabled)
            ->setDefault_moh_list($default_moh_list)
            ->setCustomer_defined_moh_list($customer_defined_moh_list)
            ->setAggregated_moh_list($aggregated_moh_list);
    }
    /**
     * Get system_default_i_moh value
     * @return int|null
     */
    public function getSystem_default_i_moh()
    {
        return $this->system_default_i_moh;
    }
    /**
     * Set system_default_i_moh value
     * @param int $system_default_i_moh
     * @return \StructType\MOHListInfo
     */
    public function setSystem_default_i_moh($system_default_i_moh = null)
    {
        // validation for constraint: int
        if (!is_null($system_default_i_moh) && !is_numeric($system_default_i_moh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($system_default_i_moh)), __LINE__);
        }
        $this->system_default_i_moh = $system_default_i_moh;
        return $this;
    }
    /**
     * Get is_moh_update_disabled value
     * @return int|null
     */
    public function getIs_moh_update_disabled()
    {
        return $this->is_moh_update_disabled;
    }
    /**
     * Set is_moh_update_disabled value
     * @param int $is_moh_update_disabled
     * @return \StructType\MOHListInfo
     */
    public function setIs_moh_update_disabled($is_moh_update_disabled = null)
    {
        // validation for constraint: int
        if (!is_null($is_moh_update_disabled) && !is_numeric($is_moh_update_disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_moh_update_disabled)), __LINE__);
        }
        $this->is_moh_update_disabled = $is_moh_update_disabled;
        return $this;
    }
    /**
     * Get default_moh_list value
     * @return \StructType\MOHInfo[]|null
     */
    public function getDefault_moh_list()
    {
        return $this->default_moh_list;
    }
    /**
     * Set default_moh_list value
     * @throws \InvalidArgumentException
     * @param \StructType\MOHInfo[] $default_moh_list
     * @return \StructType\MOHListInfo
     */
    public function setDefault_moh_list(array $default_moh_list = array())
    {
        foreach ($default_moh_list as $mOHListInfoDefault_moh_listItem) {
            // validation for constraint: itemType
            if (!$mOHListInfoDefault_moh_listItem instanceof \StructType\MOHInfo) {
                throw new \InvalidArgumentException(sprintf('The default_moh_list property can only contain items of \StructType\MOHInfo, "%s" given', is_object($mOHListInfoDefault_moh_listItem) ? get_class($mOHListInfoDefault_moh_listItem) : gettype($mOHListInfoDefault_moh_listItem)), __LINE__);
            }
        }
        $this->default_moh_list = $default_moh_list;
        return $this;
    }
    /**
     * Add item to default_moh_list value
     * @throws \InvalidArgumentException
     * @param \StructType\MOHInfo $item
     * @return \StructType\MOHListInfo
     */
    public function addToDefault_moh_list(\StructType\MOHInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MOHInfo) {
            throw new \InvalidArgumentException(sprintf('The default_moh_list property can only contain items of \StructType\MOHInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->default_moh_list[] = $item;
        return $this;
    }
    /**
     * Get customer_defined_moh_list value
     * @return \StructType\MOHInfo[]|null
     */
    public function getCustomer_defined_moh_list()
    {
        return $this->customer_defined_moh_list;
    }
    /**
     * Set customer_defined_moh_list value
     * @throws \InvalidArgumentException
     * @param \StructType\MOHInfo[] $customer_defined_moh_list
     * @return \StructType\MOHListInfo
     */
    public function setCustomer_defined_moh_list(array $customer_defined_moh_list = array())
    {
        foreach ($customer_defined_moh_list as $mOHListInfoCustomer_defined_moh_listItem) {
            // validation for constraint: itemType
            if (!$mOHListInfoCustomer_defined_moh_listItem instanceof \StructType\MOHInfo) {
                throw new \InvalidArgumentException(sprintf('The customer_defined_moh_list property can only contain items of \StructType\MOHInfo, "%s" given', is_object($mOHListInfoCustomer_defined_moh_listItem) ? get_class($mOHListInfoCustomer_defined_moh_listItem) : gettype($mOHListInfoCustomer_defined_moh_listItem)), __LINE__);
            }
        }
        $this->customer_defined_moh_list = $customer_defined_moh_list;
        return $this;
    }
    /**
     * Add item to customer_defined_moh_list value
     * @throws \InvalidArgumentException
     * @param \StructType\MOHInfo $item
     * @return \StructType\MOHListInfo
     */
    public function addToCustomer_defined_moh_list(\StructType\MOHInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MOHInfo) {
            throw new \InvalidArgumentException(sprintf('The customer_defined_moh_list property can only contain items of \StructType\MOHInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customer_defined_moh_list[] = $item;
        return $this;
    }
    /**
     * Get aggregated_moh_list value
     * @return \StructType\MOHInfo[]|null
     */
    public function getAggregated_moh_list()
    {
        return $this->aggregated_moh_list;
    }
    /**
     * Set aggregated_moh_list value
     * @throws \InvalidArgumentException
     * @param \StructType\MOHInfo[] $aggregated_moh_list
     * @return \StructType\MOHListInfo
     */
    public function setAggregated_moh_list(array $aggregated_moh_list = array())
    {
        foreach ($aggregated_moh_list as $mOHListInfoAggregated_moh_listItem) {
            // validation for constraint: itemType
            if (!$mOHListInfoAggregated_moh_listItem instanceof \StructType\MOHInfo) {
                throw new \InvalidArgumentException(sprintf('The aggregated_moh_list property can only contain items of \StructType\MOHInfo, "%s" given', is_object($mOHListInfoAggregated_moh_listItem) ? get_class($mOHListInfoAggregated_moh_listItem) : gettype($mOHListInfoAggregated_moh_listItem)), __LINE__);
            }
        }
        $this->aggregated_moh_list = $aggregated_moh_list;
        return $this;
    }
    /**
     * Add item to aggregated_moh_list value
     * @throws \InvalidArgumentException
     * @param \StructType\MOHInfo $item
     * @return \StructType\MOHListInfo
     */
    public function addToAggregated_moh_list(\StructType\MOHInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MOHInfo) {
            throw new \InvalidArgumentException(sprintf('The aggregated_moh_list property can only contain items of \StructType\MOHInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->aggregated_moh_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MOHListInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
