<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HGInfo StructType
 * @subpackage Structs
 */
class HGInfo extends AbstractStructBase
{
    /**
     * The i_c_group
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_c_group;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The hunt_sequence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hunt_sequence;
    /**
     * The hunt_keep_original_cli
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hunt_keep_original_cli;
    /**
     * The i_c_ext
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_c_ext;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The assigned_extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:AssignedExtensionsInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\AssignedExtensionsInfo[]
     */
    public $assigned_extensions;
    /**
     * The i_prompt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $i_prompt;
    /**
     * The prompt_status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prompt_status;
    /**
     * The prompt_error
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prompt_error;
    /**
     * The published
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $published;
    /**
     * The pickup_allowed
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pickup_allowed;
    /**
     * Constructor method for HGInfo
     * @uses HGInfo::setI_c_group()
     * @uses HGInfo::setI_customer()
     * @uses HGInfo::setName()
     * @uses HGInfo::setHunt_sequence()
     * @uses HGInfo::setHunt_keep_original_cli()
     * @uses HGInfo::setI_c_ext()
     * @uses HGInfo::setId()
     * @uses HGInfo::setAssigned_extensions()
     * @uses HGInfo::setI_prompt()
     * @uses HGInfo::setPrompt_status()
     * @uses HGInfo::setPrompt_error()
     * @uses HGInfo::setPublished()
     * @uses HGInfo::setPickup_allowed()
     * @param int $i_c_group
     * @param int $i_customer
     * @param string $name
     * @param string $hunt_sequence
     * @param string $hunt_keep_original_cli
     * @param int $i_c_ext
     * @param string $id
     * @param \StructType\AssignedExtensionsInfo[] $assigned_extensions
     * @param int $i_prompt
     * @param string $prompt_status
     * @param string $prompt_error
     * @param string $published
     * @param string $pickup_allowed
     */
    public function __construct($i_c_group = null, $i_customer = null, $name = null, $hunt_sequence = null, $hunt_keep_original_cli = null, $i_c_ext = null, $id = null, array $assigned_extensions = array(), $i_prompt = null, $prompt_status = null, $prompt_error = null, $published = null, $pickup_allowed = null)
    {
        $this
            ->setI_c_group($i_c_group)
            ->setI_customer($i_customer)
            ->setName($name)
            ->setHunt_sequence($hunt_sequence)
            ->setHunt_keep_original_cli($hunt_keep_original_cli)
            ->setI_c_ext($i_c_ext)
            ->setId($id)
            ->setAssigned_extensions($assigned_extensions)
            ->setI_prompt($i_prompt)
            ->setPrompt_status($prompt_status)
            ->setPrompt_error($prompt_error)
            ->setPublished($published)
            ->setPickup_allowed($pickup_allowed);
    }
    /**
     * Get i_c_group value
     * @return int|null
     */
    public function getI_c_group()
    {
        return $this->i_c_group;
    }
    /**
     * Set i_c_group value
     * @param int $i_c_group
     * @return \StructType\HGInfo
     */
    public function setI_c_group($i_c_group = null)
    {
        // validation for constraint: int
        if (!is_null($i_c_group) && !is_numeric($i_c_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_c_group)), __LINE__);
        }
        $this->i_c_group = $i_c_group;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\HGInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\HGInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get hunt_sequence value
     * @return string|null
     */
    public function getHunt_sequence()
    {
        return $this->hunt_sequence;
    }
    /**
     * Set hunt_sequence value
     * @param string $hunt_sequence
     * @return \StructType\HGInfo
     */
    public function setHunt_sequence($hunt_sequence = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_sequence) && !is_string($hunt_sequence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_sequence)), __LINE__);
        }
        $this->hunt_sequence = $hunt_sequence;
        return $this;
    }
    /**
     * Get hunt_keep_original_cli value
     * @return string|null
     */
    public function getHunt_keep_original_cli()
    {
        return $this->hunt_keep_original_cli;
    }
    /**
     * Set hunt_keep_original_cli value
     * @param string $hunt_keep_original_cli
     * @return \StructType\HGInfo
     */
    public function setHunt_keep_original_cli($hunt_keep_original_cli = null)
    {
        // validation for constraint: string
        if (!is_null($hunt_keep_original_cli) && !is_string($hunt_keep_original_cli)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hunt_keep_original_cli)), __LINE__);
        }
        $this->hunt_keep_original_cli = $hunt_keep_original_cli;
        return $this;
    }
    /**
     * Get i_c_ext value
     * @return int|null
     */
    public function getI_c_ext()
    {
        return $this->i_c_ext;
    }
    /**
     * Set i_c_ext value
     * @param int $i_c_ext
     * @return \StructType\HGInfo
     */
    public function setI_c_ext($i_c_ext = null)
    {
        // validation for constraint: int
        if (!is_null($i_c_ext) && !is_numeric($i_c_ext)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_c_ext)), __LINE__);
        }
        $this->i_c_ext = $i_c_ext;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\HGInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get assigned_extensions value
     * @return \StructType\AssignedExtensionsInfo[]|null
     */
    public function getAssigned_extensions()
    {
        return $this->assigned_extensions;
    }
    /**
     * Set assigned_extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo[] $assigned_extensions
     * @return \StructType\HGInfo
     */
    public function setAssigned_extensions(array $assigned_extensions = array())
    {
        foreach ($assigned_extensions as $hGInfoAssigned_extensionsItem) {
            // validation for constraint: itemType
            if (!$hGInfoAssigned_extensionsItem instanceof \StructType\AssignedExtensionsInfo) {
                throw new \InvalidArgumentException(sprintf('The assigned_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($hGInfoAssigned_extensionsItem) ? get_class($hGInfoAssigned_extensionsItem) : gettype($hGInfoAssigned_extensionsItem)), __LINE__);
            }
        }
        $this->assigned_extensions = $assigned_extensions;
        return $this;
    }
    /**
     * Add item to assigned_extensions value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedExtensionsInfo $item
     * @return \StructType\HGInfo
     */
    public function addToAssigned_extensions(\StructType\AssignedExtensionsInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedExtensionsInfo) {
            throw new \InvalidArgumentException(sprintf('The assigned_extensions property can only contain items of \StructType\AssignedExtensionsInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->assigned_extensions[] = $item;
        return $this;
    }
    /**
     * Get i_prompt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getI_prompt()
    {
        return isset($this->i_prompt) ? $this->i_prompt : null;
    }
    /**
     * Set i_prompt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $i_prompt
     * @return \StructType\HGInfo
     */
    public function setI_prompt($i_prompt = null)
    {
        // validation for constraint: int
        if (!is_null($i_prompt) && !is_numeric($i_prompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_prompt)), __LINE__);
        }
        if (is_null($i_prompt) || (is_array($i_prompt) && empty($i_prompt))) {
            unset($this->i_prompt);
        } else {
            $this->i_prompt = $i_prompt;
        }
        return $this;
    }
    /**
     * Get prompt_status value
     * @return string|null
     */
    public function getPrompt_status()
    {
        return $this->prompt_status;
    }
    /**
     * Set prompt_status value
     * @param string $prompt_status
     * @return \StructType\HGInfo
     */
    public function setPrompt_status($prompt_status = null)
    {
        // validation for constraint: string
        if (!is_null($prompt_status) && !is_string($prompt_status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prompt_status)), __LINE__);
        }
        $this->prompt_status = $prompt_status;
        return $this;
    }
    /**
     * Get prompt_error value
     * @return string|null
     */
    public function getPrompt_error()
    {
        return $this->prompt_error;
    }
    /**
     * Set prompt_error value
     * @param string $prompt_error
     * @return \StructType\HGInfo
     */
    public function setPrompt_error($prompt_error = null)
    {
        // validation for constraint: string
        if (!is_null($prompt_error) && !is_string($prompt_error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prompt_error)), __LINE__);
        }
        $this->prompt_error = $prompt_error;
        return $this;
    }
    /**
     * Get published value
     * @return string|null
     */
    public function getPublished()
    {
        return $this->published;
    }
    /**
     * Set published value
     * @param string $published
     * @return \StructType\HGInfo
     */
    public function setPublished($published = null)
    {
        // validation for constraint: string
        if (!is_null($published) && !is_string($published)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($published)), __LINE__);
        }
        $this->published = $published;
        return $this;
    }
    /**
     * Get pickup_allowed value
     * @return string|null
     */
    public function getPickup_allowed()
    {
        return $this->pickup_allowed;
    }
    /**
     * Set pickup_allowed value
     * @param string $pickup_allowed
     * @return \StructType\HGInfo
     */
    public function setPickup_allowed($pickup_allowed = null)
    {
        // validation for constraint: string
        if (!is_null($pickup_allowed) && !is_string($pickup_allowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pickup_allowed)), __LINE__);
        }
        $this->pickup_allowed = $pickup_allowed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HGInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
