<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVendorBatchListRequest StructType
 * @subpackage Structs
 */
class GetVendorBatchListRequest extends AbstractStructBase
{
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The area_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $area_code;
    /**
     * The area_code_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $area_code_description;
    /**
     * The get_used
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $get_used;
    /**
     * The owner_batch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $owner_batch;
    /**
     * The reserve_term
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $reserve_term;
    /**
     * The limit
     * @var int
     */
    public $limit;
    /**
     * The offset
     * @var int
     */
    public $offset;
    /**
     * Constructor method for GetVendorBatchListRequest
     * @uses GetVendorBatchListRequest::setCountry()
     * @uses GetVendorBatchListRequest::setArea_code()
     * @uses GetVendorBatchListRequest::setArea_code_description()
     * @uses GetVendorBatchListRequest::setGet_used()
     * @uses GetVendorBatchListRequest::setOwner_batch()
     * @uses GetVendorBatchListRequest::setReserve_term()
     * @uses GetVendorBatchListRequest::setLimit()
     * @uses GetVendorBatchListRequest::setOffset()
     * @param string $country
     * @param string $area_code
     * @param string $area_code_description
     * @param int $get_used
     * @param int $owner_batch
     * @param int $reserve_term
     * @param int $limit
     * @param int $offset
     */
    public function __construct($country = null, $area_code = null, $area_code_description = null, $get_used = null, $owner_batch = null, $reserve_term = null, $limit = null, $offset = null)
    {
        $this
            ->setCountry($country)
            ->setArea_code($area_code)
            ->setArea_code_description($area_code_description)
            ->setGet_used($get_used)
            ->setOwner_batch($owner_batch)
            ->setReserve_term($reserve_term)
            ->setLimit($limit)
            ->setOffset($offset);
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get area_code value
     * @return string|null
     */
    public function getArea_code()
    {
        return $this->area_code;
    }
    /**
     * Set area_code value
     * @param string $area_code
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setArea_code($area_code = null)
    {
        // validation for constraint: string
        if (!is_null($area_code) && !is_string($area_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_code)), __LINE__);
        }
        $this->area_code = $area_code;
        return $this;
    }
    /**
     * Get area_code_description value
     * @return string|null
     */
    public function getArea_code_description()
    {
        return $this->area_code_description;
    }
    /**
     * Set area_code_description value
     * @param string $area_code_description
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setArea_code_description($area_code_description = null)
    {
        // validation for constraint: string
        if (!is_null($area_code_description) && !is_string($area_code_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_code_description)), __LINE__);
        }
        $this->area_code_description = $area_code_description;
        return $this;
    }
    /**
     * Get get_used value
     * @return int|null
     */
    public function getGet_used()
    {
        return $this->get_used;
    }
    /**
     * Set get_used value
     * @param int $get_used
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setGet_used($get_used = null)
    {
        // validation for constraint: int
        if (!is_null($get_used) && !is_numeric($get_used)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_used)), __LINE__);
        }
        $this->get_used = $get_used;
        return $this;
    }
    /**
     * Get owner_batch value
     * @return int|null
     */
    public function getOwner_batch()
    {
        return $this->owner_batch;
    }
    /**
     * Set owner_batch value
     * @param int $owner_batch
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setOwner_batch($owner_batch = null)
    {
        // validation for constraint: int
        if (!is_null($owner_batch) && !is_numeric($owner_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($owner_batch)), __LINE__);
        }
        $this->owner_batch = $owner_batch;
        return $this;
    }
    /**
     * Get reserve_term value
     * @return int|null
     */
    public function getReserve_term()
    {
        return $this->reserve_term;
    }
    /**
     * Set reserve_term value
     * @param int $reserve_term
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setReserve_term($reserve_term = null)
    {
        // validation for constraint: int
        if (!is_null($reserve_term) && !is_numeric($reserve_term)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reserve_term)), __LINE__);
        }
        $this->reserve_term = $reserve_term;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetVendorBatchListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVendorBatchListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
