<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVDThresholdListResponse StructType
 * @subpackage Structs
 */
class GetVDThresholdListResponse extends AbstractStructBase
{
    /**
     * The threshold_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:VDThresholdInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\VDThresholdInfo[]
     */
    public $threshold_list;
    /**
     * Constructor method for GetVDThresholdListResponse
     * @uses GetVDThresholdListResponse::setThreshold_list()
     * @param \StructType\VDThresholdInfo[] $threshold_list
     */
    public function __construct(array $threshold_list = array())
    {
        $this
            ->setThreshold_list($threshold_list);
    }
    /**
     * Get threshold_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\VDThresholdInfo[]|null
     */
    public function getThreshold_list()
    {
        return isset($this->threshold_list) ? $this->threshold_list : null;
    }
    /**
     * Set threshold_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VDThresholdInfo[] $threshold_list
     * @return \StructType\GetVDThresholdListResponse
     */
    public function setThreshold_list(array $threshold_list = array())
    {
        foreach ($threshold_list as $getVDThresholdListResponseThreshold_listItem) {
            // validation for constraint: itemType
            if (!$getVDThresholdListResponseThreshold_listItem instanceof \StructType\VDThresholdInfo) {
                throw new \InvalidArgumentException(sprintf('The threshold_list property can only contain items of \StructType\VDThresholdInfo, "%s" given', is_object($getVDThresholdListResponseThreshold_listItem) ? get_class($getVDThresholdListResponseThreshold_listItem) : gettype($getVDThresholdListResponseThreshold_listItem)), __LINE__);
            }
        }
        if (is_null($threshold_list) || (is_array($threshold_list) && empty($threshold_list))) {
            unset($this->threshold_list);
        } else {
            $this->threshold_list = $threshold_list;
        }
        return $this;
    }
    /**
     * Add item to threshold_list value
     * @throws \InvalidArgumentException
     * @param \StructType\VDThresholdInfo $item
     * @return \StructType\GetVDThresholdListResponse
     */
    public function addToThreshold_list(\StructType\VDThresholdInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VDThresholdInfo) {
            throw new \InvalidArgumentException(sprintf('The threshold_list property can only contain items of \StructType\VDThresholdInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->threshold_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVDThresholdListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
