<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSubdivisionsListResponse StructType
 * @subpackage Structs
 */
class GetSubdivisionsListResponse extends AbstractStructBase
{
    /**
     * The subdivisions_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:SubdivisionInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\SubdivisionInfo[]
     */
    public $subdivisions_list;
    /**
     * Constructor method for GetSubdivisionsListResponse
     * @uses GetSubdivisionsListResponse::setSubdivisions_list()
     * @param \StructType\SubdivisionInfo[] $subdivisions_list
     */
    public function __construct(array $subdivisions_list = array())
    {
        $this
            ->setSubdivisions_list($subdivisions_list);
    }
    /**
     * Get subdivisions_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubdivisionInfo[]|null
     */
    public function getSubdivisions_list()
    {
        return isset($this->subdivisions_list) ? $this->subdivisions_list : null;
    }
    /**
     * Set subdivisions_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubdivisionInfo[] $subdivisions_list
     * @return \StructType\GetSubdivisionsListResponse
     */
    public function setSubdivisions_list(array $subdivisions_list = array())
    {
        foreach ($subdivisions_list as $getSubdivisionsListResponseSubdivisions_listItem) {
            // validation for constraint: itemType
            if (!$getSubdivisionsListResponseSubdivisions_listItem instanceof \StructType\SubdivisionInfo) {
                throw new \InvalidArgumentException(sprintf('The subdivisions_list property can only contain items of \StructType\SubdivisionInfo, "%s" given', is_object($getSubdivisionsListResponseSubdivisions_listItem) ? get_class($getSubdivisionsListResponseSubdivisions_listItem) : gettype($getSubdivisionsListResponseSubdivisions_listItem)), __LINE__);
            }
        }
        if (is_null($subdivisions_list) || (is_array($subdivisions_list) && empty($subdivisions_list))) {
            unset($this->subdivisions_list);
        } else {
            $this->subdivisions_list = $subdivisions_list;
        }
        return $this;
    }
    /**
     * Add item to subdivisions_list value
     * @throws \InvalidArgumentException
     * @param \StructType\SubdivisionInfo $item
     * @return \StructType\GetSubdivisionsListResponse
     */
    public function addToSubdivisions_list(\StructType\SubdivisionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubdivisionInfo) {
            throw new \InvalidArgumentException(sprintf('The subdivisions_list property can only contain items of \StructType\SubdivisionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subdivisions_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSubdivisionsListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
