<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetServiceListResponse StructType
 * @subpackage Structs
 */
class GetServiceListResponse extends AbstractStructBase
{
    /**
     * The service_list
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: pst:ServiceInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceInfo[]
     */
    public $service_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetServiceListResponse
     * @uses GetServiceListResponse::setService_list()
     * @uses GetServiceListResponse::setTotal()
     * @param \StructType\ServiceInfo[] $service_list
     * @param int $total
     */
    public function __construct(array $service_list = array(), $total = null)
    {
        $this
            ->setService_list($service_list)
            ->setTotal($total);
    }
    /**
     * Get service_list value
     * @return \StructType\ServiceInfo[]|null
     */
    public function getService_list()
    {
        return $this->service_list;
    }
    /**
     * Set service_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceInfo[] $service_list
     * @return \StructType\GetServiceListResponse
     */
    public function setService_list(array $service_list = array())
    {
        foreach ($service_list as $getServiceListResponseService_listItem) {
            // validation for constraint: itemType
            if (!$getServiceListResponseService_listItem instanceof \StructType\ServiceInfo) {
                throw new \InvalidArgumentException(sprintf('The service_list property can only contain items of \StructType\ServiceInfo, "%s" given', is_object($getServiceListResponseService_listItem) ? get_class($getServiceListResponseService_listItem) : gettype($getServiceListResponseService_listItem)), __LINE__);
            }
        }
        $this->service_list = $service_list;
        return $this;
    }
    /**
     * Add item to service_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceInfo $item
     * @return \StructType\GetServiceListResponse
     */
    public function addToService_list(\StructType\ServiceInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceInfo) {
            throw new \InvalidArgumentException(sprintf('The service_list property can only contain items of \StructType\ServiceInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetServiceListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetServiceListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
