<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRouteListRequest StructType
 * @subpackage Structs
 */
class GetRouteListRequest extends AbstractStructBase
{
    /**
     * The number
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $number;
    /**
     * The i_routing_plan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_routing_plan;
    /**
     * The i_node
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_node;
    /**
     * The apply_penalties
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $apply_penalties;
    /**
     * The effective_time
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $effective_time;
    /**
     * Constructor method for GetRouteListRequest
     * @uses GetRouteListRequest::setNumber()
     * @uses GetRouteListRequest::setI_routing_plan()
     * @uses GetRouteListRequest::setI_node()
     * @uses GetRouteListRequest::setApply_penalties()
     * @uses GetRouteListRequest::setEffective_time()
     * @param string $number
     * @param int $i_routing_plan
     * @param int $i_node
     * @param int $apply_penalties
     * @param string $effective_time
     */
    public function __construct($number = null, $i_routing_plan = null, $i_node = null, $apply_penalties = null, $effective_time = null)
    {
        $this
            ->setNumber($number)
            ->setI_routing_plan($i_routing_plan)
            ->setI_node($i_node)
            ->setApply_penalties($apply_penalties)
            ->setEffective_time($effective_time);
    }
    /**
     * Get number value
     * @return string
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \StructType\GetRouteListRequest
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get i_routing_plan value
     * @return int|null
     */
    public function getI_routing_plan()
    {
        return $this->i_routing_plan;
    }
    /**
     * Set i_routing_plan value
     * @param int $i_routing_plan
     * @return \StructType\GetRouteListRequest
     */
    public function setI_routing_plan($i_routing_plan = null)
    {
        // validation for constraint: int
        if (!is_null($i_routing_plan) && !is_numeric($i_routing_plan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_routing_plan)), __LINE__);
        }
        $this->i_routing_plan = $i_routing_plan;
        return $this;
    }
    /**
     * Get i_node value
     * @return int|null
     */
    public function getI_node()
    {
        return $this->i_node;
    }
    /**
     * Set i_node value
     * @param int $i_node
     * @return \StructType\GetRouteListRequest
     */
    public function setI_node($i_node = null)
    {
        // validation for constraint: int
        if (!is_null($i_node) && !is_numeric($i_node)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_node)), __LINE__);
        }
        $this->i_node = $i_node;
        return $this;
    }
    /**
     * Get apply_penalties value
     * @return int|null
     */
    public function getApply_penalties()
    {
        return $this->apply_penalties;
    }
    /**
     * Set apply_penalties value
     * @param int $apply_penalties
     * @return \StructType\GetRouteListRequest
     */
    public function setApply_penalties($apply_penalties = null)
    {
        // validation for constraint: int
        if (!is_null($apply_penalties) && !is_numeric($apply_penalties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($apply_penalties)), __LINE__);
        }
        $this->apply_penalties = $apply_penalties;
        return $this;
    }
    /**
     * Get effective_time value
     * @return string|null
     */
    public function getEffective_time()
    {
        return $this->effective_time;
    }
    /**
     * Set effective_time value
     * @param string $effective_time
     * @return \StructType\GetRouteListRequest
     */
    public function setEffective_time($effective_time = null)
    {
        // validation for constraint: string
        if (!is_null($effective_time) && !is_string($effective_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effective_time)), __LINE__);
        }
        $this->effective_time = $effective_time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRouteListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
