<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRateListResponse StructType
 * @subpackage Structs
 */
class GetRateListResponse extends AbstractStructBase
{
    /**
     * The rate_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:RateInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\RateInfo[]
     */
    public $rate_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetRateListResponse
     * @uses GetRateListResponse::setRate_list()
     * @uses GetRateListResponse::setTotal()
     * @param \StructType\RateInfo[] $rate_list
     * @param int $total
     */
    public function __construct(array $rate_list = array(), $total = null)
    {
        $this
            ->setRate_list($rate_list)
            ->setTotal($total);
    }
    /**
     * Get rate_list value
     * @return \StructType\RateInfo[]|null
     */
    public function getRate_list()
    {
        return $this->rate_list;
    }
    /**
     * Set rate_list value
     * @throws \InvalidArgumentException
     * @param \StructType\RateInfo[] $rate_list
     * @return \StructType\GetRateListResponse
     */
    public function setRate_list(array $rate_list = array())
    {
        foreach ($rate_list as $getRateListResponseRate_listItem) {
            // validation for constraint: itemType
            if (!$getRateListResponseRate_listItem instanceof \StructType\RateInfo) {
                throw new \InvalidArgumentException(sprintf('The rate_list property can only contain items of \StructType\RateInfo, "%s" given', is_object($getRateListResponseRate_listItem) ? get_class($getRateListResponseRate_listItem) : gettype($getRateListResponseRate_listItem)), __LINE__);
            }
        }
        $this->rate_list = $rate_list;
        return $this;
    }
    /**
     * Add item to rate_list value
     * @throws \InvalidArgumentException
     * @param \StructType\RateInfo $item
     * @return \StructType\GetRateListResponse
     */
    public function addToRate_list(\StructType\RateInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RateInfo) {
            throw new \InvalidArgumentException(sprintf('The rate_list property can only contain items of \StructType\RateInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rate_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetRateListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRateListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
