<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRateListRequest StructType
 * @subpackage Structs
 */
class GetRateListRequest extends AbstractStructBase
{
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $offset;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The i_tariff
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_tariff;
    /**
     * The effective_from
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $effective_from;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $destination;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $get_total;
    /**
     * The order_by
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_by;
    /**
     * The order_direction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $order_direction;
    /**
     * The extended_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $extended_info;
    /**
     * Constructor method for GetRateListRequest
     * @uses GetRateListRequest::setOffset()
     * @uses GetRateListRequest::setLimit()
     * @uses GetRateListRequest::setI_tariff()
     * @uses GetRateListRequest::setEffective_from()
     * @uses GetRateListRequest::setType()
     * @uses GetRateListRequest::setDestination()
     * @uses GetRateListRequest::setGet_total()
     * @uses GetRateListRequest::setOrder_by()
     * @uses GetRateListRequest::setOrder_direction()
     * @uses GetRateListRequest::setExtended_info()
     * @param int $offset
     * @param int $limit
     * @param int $i_tariff
     * @param string $effective_from
     * @param string $type
     * @param string $destination
     * @param int $get_total
     * @param string $order_by
     * @param string $order_direction
     * @param int $extended_info
     */
    public function __construct($offset = null, $limit = null, $i_tariff = null, $effective_from = null, $type = null, $destination = null, $get_total = null, $order_by = null, $order_direction = null, $extended_info = null)
    {
        $this
            ->setOffset($offset)
            ->setLimit($limit)
            ->setI_tariff($i_tariff)
            ->setEffective_from($effective_from)
            ->setType($type)
            ->setDestination($destination)
            ->setGet_total($get_total)
            ->setOrder_by($order_by)
            ->setOrder_direction($order_direction)
            ->setExtended_info($extended_info);
    }
    /**
     * Get offset value
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetRateListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetRateListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get i_tariff value
     * @return int
     */
    public function getI_tariff()
    {
        return $this->i_tariff;
    }
    /**
     * Set i_tariff value
     * @param int $i_tariff
     * @return \StructType\GetRateListRequest
     */
    public function setI_tariff($i_tariff = null)
    {
        // validation for constraint: int
        if (!is_null($i_tariff) && !is_numeric($i_tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_tariff)), __LINE__);
        }
        $this->i_tariff = $i_tariff;
        return $this;
    }
    /**
     * Get effective_from value
     * @return string|null
     */
    public function getEffective_from()
    {
        return $this->effective_from;
    }
    /**
     * Set effective_from value
     * @param string $effective_from
     * @return \StructType\GetRateListRequest
     */
    public function setEffective_from($effective_from = null)
    {
        // validation for constraint: string
        if (!is_null($effective_from) && !is_string($effective_from)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effective_from)), __LINE__);
        }
        $this->effective_from = $effective_from;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\GetRateListRequest
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get destination value
     * @return string|null
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\GetRateListRequest
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get get_total value
     * @return int|null
     */
    public function getGet_total()
    {
        return $this->get_total;
    }
    /**
     * Set get_total value
     * @param int $get_total
     * @return \StructType\GetRateListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        $this->get_total = $get_total;
        return $this;
    }
    /**
     * Get order_by value
     * @return string|null
     */
    public function getOrder_by()
    {
        return $this->order_by;
    }
    /**
     * Set order_by value
     * @param string $order_by
     * @return \StructType\GetRateListRequest
     */
    public function setOrder_by($order_by = null)
    {
        // validation for constraint: string
        if (!is_null($order_by) && !is_string($order_by)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_by)), __LINE__);
        }
        $this->order_by = $order_by;
        return $this;
    }
    /**
     * Get order_direction value
     * @return string|null
     */
    public function getOrder_direction()
    {
        return $this->order_direction;
    }
    /**
     * Set order_direction value
     * @param string $order_direction
     * @return \StructType\GetRateListRequest
     */
    public function setOrder_direction($order_direction = null)
    {
        // validation for constraint: string
        if (!is_null($order_direction) && !is_string($order_direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_direction)), __LINE__);
        }
        $this->order_direction = $order_direction;
        return $this;
    }
    /**
     * Get extended_info value
     * @return int|null
     */
    public function getExtended_info()
    {
        return $this->extended_info;
    }
    /**
     * Set extended_info value
     * @param int $extended_info
     * @return \StructType\GetRateListRequest
     */
    public function setExtended_info($extended_info = null)
    {
        // validation for constraint: int
        if (!is_null($extended_info) && !is_numeric($extended_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($extended_info)), __LINE__);
        }
        $this->extended_info = $extended_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetRateListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
