<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPromptFileRequest StructType
 * @subpackage Structs
 */
class GetPromptFileRequest extends AbstractStructBase
{
    /**
     * The i_prompt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_prompt;
    /**
     * The codec
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $codec;
    /**
     * The description_only
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $description_only;
    /**
     * Constructor method for GetPromptFileRequest
     * @uses GetPromptFileRequest::setI_prompt()
     * @uses GetPromptFileRequest::setCodec()
     * @uses GetPromptFileRequest::setDescription_only()
     * @param int $i_prompt
     * @param string $codec
     * @param int $description_only
     */
    public function __construct($i_prompt = null, $codec = null, $description_only = null)
    {
        $this
            ->setI_prompt($i_prompt)
            ->setCodec($codec)
            ->setDescription_only($description_only);
    }
    /**
     * Get i_prompt value
     * @return int
     */
    public function getI_prompt()
    {
        return $this->i_prompt;
    }
    /**
     * Set i_prompt value
     * @param int $i_prompt
     * @return \StructType\GetPromptFileRequest
     */
    public function setI_prompt($i_prompt = null)
    {
        // validation for constraint: int
        if (!is_null($i_prompt) && !is_numeric($i_prompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_prompt)), __LINE__);
        }
        $this->i_prompt = $i_prompt;
        return $this;
    }
    /**
     * Get codec value
     * @return string
     */
    public function getCodec()
    {
        return $this->codec;
    }
    /**
     * Set codec value
     * @param string $codec
     * @return \StructType\GetPromptFileRequest
     */
    public function setCodec($codec = null)
    {
        // validation for constraint: string
        if (!is_null($codec) && !is_string($codec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codec)), __LINE__);
        }
        $this->codec = $codec;
        return $this;
    }
    /**
     * Get description_only value
     * @return int|null
     */
    public function getDescription_only()
    {
        return $this->description_only;
    }
    /**
     * Set description_only value
     * @param int $description_only
     * @return \StructType\GetPromptFileRequest
     */
    public function setDescription_only($description_only = null)
    {
        // validation for constraint: int
        if (!is_null($description_only) && !is_numeric($description_only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($description_only)), __LINE__);
        }
        $this->description_only = $description_only;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPromptFileRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
