<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPhoneBookListResponse StructType
 * @subpackage Structs
 */
class GetPhoneBookListResponse extends AbstractStructBase
{
    /**
     * The phonebook_rec_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:PhoneBookRecInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\PhoneBookRecInfo[]
     */
    public $phonebook_rec_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetPhoneBookListResponse
     * @uses GetPhoneBookListResponse::setPhonebook_rec_list()
     * @uses GetPhoneBookListResponse::setTotal()
     * @param \StructType\PhoneBookRecInfo[] $phonebook_rec_list
     * @param int $total
     */
    public function __construct(array $phonebook_rec_list = array(), $total = null)
    {
        $this
            ->setPhonebook_rec_list($phonebook_rec_list)
            ->setTotal($total);
    }
    /**
     * Get phonebook_rec_list value
     * @return \StructType\PhoneBookRecInfo[]|null
     */
    public function getPhonebook_rec_list()
    {
        return $this->phonebook_rec_list;
    }
    /**
     * Set phonebook_rec_list value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneBookRecInfo[] $phonebook_rec_list
     * @return \StructType\GetPhoneBookListResponse
     */
    public function setPhonebook_rec_list(array $phonebook_rec_list = array())
    {
        foreach ($phonebook_rec_list as $getPhoneBookListResponsePhonebook_rec_listItem) {
            // validation for constraint: itemType
            if (!$getPhoneBookListResponsePhonebook_rec_listItem instanceof \StructType\PhoneBookRecInfo) {
                throw new \InvalidArgumentException(sprintf('The phonebook_rec_list property can only contain items of \StructType\PhoneBookRecInfo, "%s" given', is_object($getPhoneBookListResponsePhonebook_rec_listItem) ? get_class($getPhoneBookListResponsePhonebook_rec_listItem) : gettype($getPhoneBookListResponsePhonebook_rec_listItem)), __LINE__);
            }
        }
        $this->phonebook_rec_list = $phonebook_rec_list;
        return $this;
    }
    /**
     * Add item to phonebook_rec_list value
     * @throws \InvalidArgumentException
     * @param \StructType\PhoneBookRecInfo $item
     * @return \StructType\GetPhoneBookListResponse
     */
    public function addToPhonebook_rec_list(\StructType\PhoneBookRecInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PhoneBookRecInfo) {
            throw new \InvalidArgumentException(sprintf('The phonebook_rec_list property can only contain items of \StructType\PhoneBookRecInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->phonebook_rec_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetPhoneBookListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPhoneBookListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
