<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentMethodsForOwnerResponse StructType
 * @subpackage Structs
 */
class GetPaymentMethodsForOwnerResponse extends AbstractStructBase
{
    /**
     * The payment_methods
     * Meta informations extracted from the WSDL
     * - nillable: true
     * - arrayType: pst:PaymentSystemInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\PaymentSystemInfo[]
     */
    public $payment_methods;
    /**
     * Constructor method for GetPaymentMethodsForOwnerResponse
     * @uses GetPaymentMethodsForOwnerResponse::setPayment_methods()
     * @param \StructType\PaymentSystemInfo[] $payment_methods
     */
    public function __construct(array $payment_methods = array())
    {
        $this
            ->setPayment_methods($payment_methods);
    }
    /**
     * Get payment_methods value
     * @return \StructType\PaymentSystemInfo[]|null
     */
    public function getPayment_methods()
    {
        return $this->payment_methods;
    }
    /**
     * Set payment_methods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentSystemInfo[] $payment_methods
     * @return \StructType\GetPaymentMethodsForOwnerResponse
     */
    public function setPayment_methods(array $payment_methods = array())
    {
        foreach ($payment_methods as $getPaymentMethodsForOwnerResponsePayment_methodsItem) {
            // validation for constraint: itemType
            if (!$getPaymentMethodsForOwnerResponsePayment_methodsItem instanceof \StructType\PaymentSystemInfo) {
                throw new \InvalidArgumentException(sprintf('The payment_methods property can only contain items of \StructType\PaymentSystemInfo, "%s" given', is_object($getPaymentMethodsForOwnerResponsePayment_methodsItem) ? get_class($getPaymentMethodsForOwnerResponsePayment_methodsItem) : gettype($getPaymentMethodsForOwnerResponsePayment_methodsItem)), __LINE__);
            }
        }
        $this->payment_methods = $payment_methods;
        return $this;
    }
    /**
     * Add item to payment_methods value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentSystemInfo $item
     * @return \StructType\GetPaymentMethodsForOwnerResponse
     */
    public function addToPayment_methods(\StructType\PaymentSystemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentSystemInfo) {
            throw new \InvalidArgumentException(sprintf('The payment_methods property can only contain items of \StructType\PaymentSystemInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment_methods[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetPaymentMethodsForOwnerResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
