<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetLinesActiveSubscriptionsResponse StructType
 * @subpackage Structs
 */
class GetLinesActiveSubscriptionsResponse extends AbstractStructBase
{
    /**
     * The subscriptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:LineSubscriptionInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\LineSubscriptionInfo[]
     */
    public $subscriptions;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetLinesActiveSubscriptionsResponse
     * @uses GetLinesActiveSubscriptionsResponse::setSubscriptions()
     * @uses GetLinesActiveSubscriptionsResponse::setTotal()
     * @param \StructType\LineSubscriptionInfo[] $subscriptions
     * @param int $total
     */
    public function __construct(array $subscriptions = array(), $total = null)
    {
        $this
            ->setSubscriptions($subscriptions)
            ->setTotal($total);
    }
    /**
     * Get subscriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineSubscriptionInfo[]|null
     */
    public function getSubscriptions()
    {
        return isset($this->subscriptions) ? $this->subscriptions : null;
    }
    /**
     * Set subscriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LineSubscriptionInfo[] $subscriptions
     * @return \StructType\GetLinesActiveSubscriptionsResponse
     */
    public function setSubscriptions(array $subscriptions = array())
    {
        foreach ($subscriptions as $getLinesActiveSubscriptionsResponseSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$getLinesActiveSubscriptionsResponseSubscriptionsItem instanceof \StructType\LineSubscriptionInfo) {
                throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\LineSubscriptionInfo, "%s" given', is_object($getLinesActiveSubscriptionsResponseSubscriptionsItem) ? get_class($getLinesActiveSubscriptionsResponseSubscriptionsItem) : gettype($getLinesActiveSubscriptionsResponseSubscriptionsItem)), __LINE__);
            }
        }
        if (is_null($subscriptions) || (is_array($subscriptions) && empty($subscriptions))) {
            unset($this->subscriptions);
        } else {
            $this->subscriptions = $subscriptions;
        }
        return $this;
    }
    /**
     * Add item to subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\LineSubscriptionInfo $item
     * @return \StructType\GetLinesActiveSubscriptionsResponse
     */
    public function addToSubscriptions(\StructType\LineSubscriptionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineSubscriptionInfo) {
            throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\LineSubscriptionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subscriptions[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetLinesActiveSubscriptionsResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetLinesActiveSubscriptionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
