<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetFullVDCounterListInfoResponse StructType
 * @subpackage Structs
 */
class GetFullVDCounterListInfoResponse extends AbstractStructBase
{
    /**
     * The counter_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:FullCounterInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\FullCounterInfo[]
     */
    public $counter_list;
    /**
     * Constructor method for GetFullVDCounterListInfoResponse
     * @uses GetFullVDCounterListInfoResponse::setCounter_list()
     * @param \StructType\FullCounterInfo[] $counter_list
     */
    public function __construct(array $counter_list = array())
    {
        $this
            ->setCounter_list($counter_list);
    }
    /**
     * Get counter_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FullCounterInfo[]|null
     */
    public function getCounter_list()
    {
        return isset($this->counter_list) ? $this->counter_list : null;
    }
    /**
     * Set counter_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FullCounterInfo[] $counter_list
     * @return \StructType\GetFullVDCounterListInfoResponse
     */
    public function setCounter_list(array $counter_list = array())
    {
        foreach ($counter_list as $getFullVDCounterListInfoResponseCounter_listItem) {
            // validation for constraint: itemType
            if (!$getFullVDCounterListInfoResponseCounter_listItem instanceof \StructType\FullCounterInfo) {
                throw new \InvalidArgumentException(sprintf('The counter_list property can only contain items of \StructType\FullCounterInfo, "%s" given', is_object($getFullVDCounterListInfoResponseCounter_listItem) ? get_class($getFullVDCounterListInfoResponseCounter_listItem) : gettype($getFullVDCounterListInfoResponseCounter_listItem)), __LINE__);
            }
        }
        if (is_null($counter_list) || (is_array($counter_list) && empty($counter_list))) {
            unset($this->counter_list);
        } else {
            $this->counter_list = $counter_list;
        }
        return $this;
    }
    /**
     * Add item to counter_list value
     * @throws \InvalidArgumentException
     * @param \StructType\FullCounterInfo $item
     * @return \StructType\GetFullVDCounterListInfoResponse
     */
    public function addToCounter_list(\StructType\FullCounterInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FullCounterInfo) {
            throw new \InvalidArgumentException(sprintf('The counter_list property can only contain items of \StructType\FullCounterInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->counter_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetFullVDCounterListInfoResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
