<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDiscountPlanListResponse StructType
 * @subpackage Structs
 */
class GetDiscountPlanListResponse extends AbstractStructBase
{
    /**
     * The discount_plan_list
     * Meta informations extracted from the WSDL
     * - arrayType: pst:DiscountPlanInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DiscountPlanInfo[]
     */
    public $discount_plan_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetDiscountPlanListResponse
     * @uses GetDiscountPlanListResponse::setDiscount_plan_list()
     * @uses GetDiscountPlanListResponse::setTotal()
     * @param \StructType\DiscountPlanInfo[] $discount_plan_list
     * @param int $total
     */
    public function __construct(array $discount_plan_list = array(), $total = null)
    {
        $this
            ->setDiscount_plan_list($discount_plan_list)
            ->setTotal($total);
    }
    /**
     * Get discount_plan_list value
     * @return \StructType\DiscountPlanInfo[]|null
     */
    public function getDiscount_plan_list()
    {
        return $this->discount_plan_list;
    }
    /**
     * Set discount_plan_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountPlanInfo[] $discount_plan_list
     * @return \StructType\GetDiscountPlanListResponse
     */
    public function setDiscount_plan_list(array $discount_plan_list = array())
    {
        foreach ($discount_plan_list as $getDiscountPlanListResponseDiscount_plan_listItem) {
            // validation for constraint: itemType
            if (!$getDiscountPlanListResponseDiscount_plan_listItem instanceof \StructType\DiscountPlanInfo) {
                throw new \InvalidArgumentException(sprintf('The discount_plan_list property can only contain items of \StructType\DiscountPlanInfo, "%s" given', is_object($getDiscountPlanListResponseDiscount_plan_listItem) ? get_class($getDiscountPlanListResponseDiscount_plan_listItem) : gettype($getDiscountPlanListResponseDiscount_plan_listItem)), __LINE__);
            }
        }
        $this->discount_plan_list = $discount_plan_list;
        return $this;
    }
    /**
     * Add item to discount_plan_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountPlanInfo $item
     * @return \StructType\GetDiscountPlanListResponse
     */
    public function addToDiscount_plan_list(\StructType\DiscountPlanInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountPlanInfo) {
            throw new \InvalidArgumentException(sprintf('The discount_plan_list property can only contain items of \StructType\DiscountPlanInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->discount_plan_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetDiscountPlanListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDiscountPlanListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
