<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDIDCountriesListResponse StructType
 * @subpackage Structs
 */
class GetDIDCountriesListResponse extends AbstractStructBase
{
    /**
     * The countries_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:DIDCountryInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\DIDCountryInfo[]
     */
    public $countries_list;
    /**
     * Constructor method for GetDIDCountriesListResponse
     * @uses GetDIDCountriesListResponse::setCountries_list()
     * @param \StructType\DIDCountryInfo[] $countries_list
     */
    public function __construct(array $countries_list = array())
    {
        $this
            ->setCountries_list($countries_list);
    }
    /**
     * Get countries_list value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DIDCountryInfo[]|null
     */
    public function getCountries_list()
    {
        return isset($this->countries_list) ? $this->countries_list : null;
    }
    /**
     * Set countries_list value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DIDCountryInfo[] $countries_list
     * @return \StructType\GetDIDCountriesListResponse
     */
    public function setCountries_list(array $countries_list = array())
    {
        foreach ($countries_list as $getDIDCountriesListResponseCountries_listItem) {
            // validation for constraint: itemType
            if (!$getDIDCountriesListResponseCountries_listItem instanceof \StructType\DIDCountryInfo) {
                throw new \InvalidArgumentException(sprintf('The countries_list property can only contain items of \StructType\DIDCountryInfo, "%s" given', is_object($getDIDCountriesListResponseCountries_listItem) ? get_class($getDIDCountriesListResponseCountries_listItem) : gettype($getDIDCountriesListResponseCountries_listItem)), __LINE__);
            }
        }
        if (is_null($countries_list) || (is_array($countries_list) && empty($countries_list))) {
            unset($this->countries_list);
        } else {
            $this->countries_list = $countries_list;
        }
        return $this;
    }
    /**
     * Add item to countries_list value
     * @throws \InvalidArgumentException
     * @param \StructType\DIDCountryInfo $item
     * @return \StructType\GetDIDCountriesListResponse
     */
    public function addToCountries_list(\StructType\DIDCountryInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DIDCountryInfo) {
            throw new \InvalidArgumentException(sprintf('The countries_list property can only contain items of \StructType\DIDCountryInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->countries_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDIDCountriesListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
