<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomerSubscriptionsResponse StructType
 * @subpackage Structs
 */
class GetCustomerSubscriptionsResponse extends AbstractStructBase
{
    /**
     * The subscriptions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CustomerSubscriptionInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomerSubscriptionInfo[]
     */
    public $subscriptions;
    /**
     * Constructor method for GetCustomerSubscriptionsResponse
     * @uses GetCustomerSubscriptionsResponse::setSubscriptions()
     * @param \StructType\CustomerSubscriptionInfo[] $subscriptions
     */
    public function __construct(array $subscriptions = array())
    {
        $this
            ->setSubscriptions($subscriptions);
    }
    /**
     * Get subscriptions value
     * @return \StructType\CustomerSubscriptionInfo[]|null
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }
    /**
     * Set subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSubscriptionInfo[] $subscriptions
     * @return \StructType\GetCustomerSubscriptionsResponse
     */
    public function setSubscriptions(array $subscriptions = array())
    {
        foreach ($subscriptions as $getCustomerSubscriptionsResponseSubscriptionsItem) {
            // validation for constraint: itemType
            if (!$getCustomerSubscriptionsResponseSubscriptionsItem instanceof \StructType\CustomerSubscriptionInfo) {
                throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\CustomerSubscriptionInfo, "%s" given', is_object($getCustomerSubscriptionsResponseSubscriptionsItem) ? get_class($getCustomerSubscriptionsResponseSubscriptionsItem) : gettype($getCustomerSubscriptionsResponseSubscriptionsItem)), __LINE__);
            }
        }
        $this->subscriptions = $subscriptions;
        return $this;
    }
    /**
     * Add item to subscriptions value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSubscriptionInfo $item
     * @return \StructType\GetCustomerSubscriptionsResponse
     */
    public function addToSubscriptions(\StructType\CustomerSubscriptionInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSubscriptionInfo) {
            throw new \InvalidArgumentException(sprintf('The subscriptions property can only contain items of \StructType\CustomerSubscriptionInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subscriptions[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomerSubscriptionsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
