<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetConnectionListRequest StructType
 * @subpackage Structs
 */
class GetConnectionListRequest extends AbstractStructBase
{
    /**
     * The i_vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_vendor;
    /**
     * The search
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $search;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $offset;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $limit;
    /**
     * Constructor method for GetConnectionListRequest
     * @uses GetConnectionListRequest::setI_vendor()
     * @uses GetConnectionListRequest::setSearch()
     * @uses GetConnectionListRequest::setOffset()
     * @uses GetConnectionListRequest::setLimit()
     * @param int $i_vendor
     * @param string $search
     * @param int $offset
     * @param int $limit
     */
    public function __construct($i_vendor = null, $search = null, $offset = null, $limit = null)
    {
        $this
            ->setI_vendor($i_vendor)
            ->setSearch($search)
            ->setOffset($offset)
            ->setLimit($limit);
    }
    /**
     * Get i_vendor value
     * @return int|null
     */
    public function getI_vendor()
    {
        return $this->i_vendor;
    }
    /**
     * Set i_vendor value
     * @param int $i_vendor
     * @return \StructType\GetConnectionListRequest
     */
    public function setI_vendor($i_vendor = null)
    {
        // validation for constraint: int
        if (!is_null($i_vendor) && !is_numeric($i_vendor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_vendor)), __LINE__);
        }
        $this->i_vendor = $i_vendor;
        return $this;
    }
    /**
     * Get search value
     * @return string|null
     */
    public function getSearch()
    {
        return $this->search;
    }
    /**
     * Set search value
     * @param string $search
     * @return \StructType\GetConnectionListRequest
     */
    public function setSearch($search = null)
    {
        // validation for constraint: string
        if (!is_null($search) && !is_string($search)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search)), __LINE__);
        }
        $this->search = $search;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetConnectionListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get limit value
     * @return int|null
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetConnectionListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetConnectionListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
