<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCPRuleListResponse StructType
 * @subpackage Structs
 */
class GetCPRuleListResponse extends AbstractStructBase
{
    /**
     * The cp_rule_list
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: pst:CPRuleInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CPRuleInfo[]
     */
    public $cp_rule_list;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * Constructor method for GetCPRuleListResponse
     * @uses GetCPRuleListResponse::setCp_rule_list()
     * @uses GetCPRuleListResponse::setTotal()
     * @param \StructType\CPRuleInfo[] $cp_rule_list
     * @param int $total
     */
    public function __construct(array $cp_rule_list = array(), $total = null)
    {
        $this
            ->setCp_rule_list($cp_rule_list)
            ->setTotal($total);
    }
    /**
     * Get cp_rule_list value
     * @return \StructType\CPRuleInfo[]|null
     */
    public function getCp_rule_list()
    {
        return $this->cp_rule_list;
    }
    /**
     * Set cp_rule_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CPRuleInfo[] $cp_rule_list
     * @return \StructType\GetCPRuleListResponse
     */
    public function setCp_rule_list(array $cp_rule_list = array())
    {
        foreach ($cp_rule_list as $getCPRuleListResponseCp_rule_listItem) {
            // validation for constraint: itemType
            if (!$getCPRuleListResponseCp_rule_listItem instanceof \StructType\CPRuleInfo) {
                throw new \InvalidArgumentException(sprintf('The cp_rule_list property can only contain items of \StructType\CPRuleInfo, "%s" given', is_object($getCPRuleListResponseCp_rule_listItem) ? get_class($getCPRuleListResponseCp_rule_listItem) : gettype($getCPRuleListResponseCp_rule_listItem)), __LINE__);
            }
        }
        $this->cp_rule_list = $cp_rule_list;
        return $this;
    }
    /**
     * Add item to cp_rule_list value
     * @throws \InvalidArgumentException
     * @param \StructType\CPRuleInfo $item
     * @return \StructType\GetCPRuleListResponse
     */
    public function addToCp_rule_list(\StructType\CPRuleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CPRuleInfo) {
            throw new \InvalidArgumentException(sprintf('The cp_rule_list property can only contain items of \StructType\CPRuleInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cp_rule_list[] = $item;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\GetCPRuleListResponse
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCPRuleListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
