<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAllowedAddonsResponse StructType
 * @subpackage Structs
 */
class GetAllowedAddonsResponse extends AbstractStructBase
{
    /**
     * The product_list
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * - arrayType: pst:ProductInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ProductInfo[]
     */
    public $product_list;
    /**
     * Constructor method for GetAllowedAddonsResponse
     * @uses GetAllowedAddonsResponse::setProduct_list()
     * @param \StructType\ProductInfo[] $product_list
     */
    public function __construct(array $product_list = array())
    {
        $this
            ->setProduct_list($product_list);
    }
    /**
     * Get product_list value
     * @return \StructType\ProductInfo[]
     */
    public function getProduct_list()
    {
        return $this->product_list;
    }
    /**
     * Set product_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo[] $product_list
     * @return \StructType\GetAllowedAddonsResponse
     */
    public function setProduct_list(array $product_list = array())
    {
        foreach ($product_list as $getAllowedAddonsResponseProduct_listItem) {
            // validation for constraint: itemType
            if (!$getAllowedAddonsResponseProduct_listItem instanceof \StructType\ProductInfo) {
                throw new \InvalidArgumentException(sprintf('The product_list property can only contain items of \StructType\ProductInfo, "%s" given', is_object($getAllowedAddonsResponseProduct_listItem) ? get_class($getAllowedAddonsResponseProduct_listItem) : gettype($getAllowedAddonsResponseProduct_listItem)), __LINE__);
            }
        }
        $this->product_list = $product_list;
        return $this;
    }
    /**
     * Add item to product_list value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductInfo $item
     * @return \StructType\GetAllowedAddonsResponse
     */
    public function addToProduct_list(\StructType\ProductInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductInfo) {
            throw new \InvalidArgumentException(sprintf('The product_list property can only contain items of \StructType\ProductInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->product_list[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAllowedAddonsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
