<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountListRequest StructType
 * @subpackage Structs
 */
class GetAccountListRequest extends AbstractStructBase
{
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $offset;
    /**
     * The limit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $limit;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The i_batch
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_batch;
    /**
     * The i_product
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_product;
    /**
     * The batch_name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $batch_name;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The get_total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $get_total;
    /**
     * The get_only_real_accounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $get_only_real_accounts;
    /**
     * The get_not_closed_accounts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $get_not_closed_accounts;
    /**
     * The legal_intercept_only
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $legal_intercept_only;
    /**
     * Constructor method for GetAccountListRequest
     * @uses GetAccountListRequest::setOffset()
     * @uses GetAccountListRequest::setLimit()
     * @uses GetAccountListRequest::setI_customer()
     * @uses GetAccountListRequest::setI_batch()
     * @uses GetAccountListRequest::setI_product()
     * @uses GetAccountListRequest::setBatch_name()
     * @uses GetAccountListRequest::setId()
     * @uses GetAccountListRequest::setGet_total()
     * @uses GetAccountListRequest::setGet_only_real_accounts()
     * @uses GetAccountListRequest::setGet_not_closed_accounts()
     * @uses GetAccountListRequest::setLegal_intercept_only()
     * @param int $offset
     * @param int $limit
     * @param int $i_customer
     * @param int $i_batch
     * @param int $i_product
     * @param string $batch_name
     * @param string $id
     * @param int $get_total
     * @param int $get_only_real_accounts
     * @param int $get_not_closed_accounts
     * @param int $legal_intercept_only
     */
    public function __construct($offset = null, $limit = null, $i_customer = null, $i_batch = null, $i_product = null, $batch_name = null, $id = null, $get_total = null, $get_only_real_accounts = null, $get_not_closed_accounts = null, $legal_intercept_only = null)
    {
        $this
            ->setOffset($offset)
            ->setLimit($limit)
            ->setI_customer($i_customer)
            ->setI_batch($i_batch)
            ->setI_product($i_product)
            ->setBatch_name($batch_name)
            ->setId($id)
            ->setGet_total($get_total)
            ->setGet_only_real_accounts($get_only_real_accounts)
            ->setGet_not_closed_accounts($get_not_closed_accounts)
            ->setLegal_intercept_only($legal_intercept_only);
    }
    /**
     * Get offset value
     * @return int
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\GetAccountListRequest
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get limit value
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }
    /**
     * Set limit value
     * @param int $limit
     * @return \StructType\GetAccountListRequest
     */
    public function setLimit($limit = null)
    {
        // validation for constraint: int
        if (!is_null($limit) && !is_numeric($limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($limit)), __LINE__);
        }
        $this->limit = $limit;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\GetAccountListRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get i_batch value
     * @return int
     */
    public function getI_batch()
    {
        return $this->i_batch;
    }
    /**
     * Set i_batch value
     * @param int $i_batch
     * @return \StructType\GetAccountListRequest
     */
    public function setI_batch($i_batch = null)
    {
        // validation for constraint: int
        if (!is_null($i_batch) && !is_numeric($i_batch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_batch)), __LINE__);
        }
        $this->i_batch = $i_batch;
        return $this;
    }
    /**
     * Get i_product value
     * @return int|null
     */
    public function getI_product()
    {
        return $this->i_product;
    }
    /**
     * Set i_product value
     * @param int $i_product
     * @return \StructType\GetAccountListRequest
     */
    public function setI_product($i_product = null)
    {
        // validation for constraint: int
        if (!is_null($i_product) && !is_numeric($i_product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_product)), __LINE__);
        }
        $this->i_product = $i_product;
        return $this;
    }
    /**
     * Get batch_name value
     * @return string|null
     */
    public function getBatch_name()
    {
        return $this->batch_name;
    }
    /**
     * Set batch_name value
     * @param string $batch_name
     * @return \StructType\GetAccountListRequest
     */
    public function setBatch_name($batch_name = null)
    {
        // validation for constraint: string
        if (!is_null($batch_name) && !is_string($batch_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($batch_name)), __LINE__);
        }
        $this->batch_name = $batch_name;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\GetAccountListRequest
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get get_total value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGet_total()
    {
        return isset($this->get_total) ? $this->get_total : null;
    }
    /**
     * Set get_total value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $get_total
     * @return \StructType\GetAccountListRequest
     */
    public function setGet_total($get_total = null)
    {
        // validation for constraint: int
        if (!is_null($get_total) && !is_numeric($get_total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_total)), __LINE__);
        }
        if (is_null($get_total) || (is_array($get_total) && empty($get_total))) {
            unset($this->get_total);
        } else {
            $this->get_total = $get_total;
        }
        return $this;
    }
    /**
     * Get get_only_real_accounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGet_only_real_accounts()
    {
        return isset($this->get_only_real_accounts) ? $this->get_only_real_accounts : null;
    }
    /**
     * Set get_only_real_accounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $get_only_real_accounts
     * @return \StructType\GetAccountListRequest
     */
    public function setGet_only_real_accounts($get_only_real_accounts = null)
    {
        // validation for constraint: int
        if (!is_null($get_only_real_accounts) && !is_numeric($get_only_real_accounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_only_real_accounts)), __LINE__);
        }
        if (is_null($get_only_real_accounts) || (is_array($get_only_real_accounts) && empty($get_only_real_accounts))) {
            unset($this->get_only_real_accounts);
        } else {
            $this->get_only_real_accounts = $get_only_real_accounts;
        }
        return $this;
    }
    /**
     * Get get_not_closed_accounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGet_not_closed_accounts()
    {
        return isset($this->get_not_closed_accounts) ? $this->get_not_closed_accounts : null;
    }
    /**
     * Set get_not_closed_accounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $get_not_closed_accounts
     * @return \StructType\GetAccountListRequest
     */
    public function setGet_not_closed_accounts($get_not_closed_accounts = null)
    {
        // validation for constraint: int
        if (!is_null($get_not_closed_accounts) && !is_numeric($get_not_closed_accounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($get_not_closed_accounts)), __LINE__);
        }
        if (is_null($get_not_closed_accounts) || (is_array($get_not_closed_accounts) && empty($get_not_closed_accounts))) {
            unset($this->get_not_closed_accounts);
        } else {
            $this->get_not_closed_accounts = $get_not_closed_accounts;
        }
        return $this;
    }
    /**
     * Get legal_intercept_only value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLegal_intercept_only()
    {
        return isset($this->legal_intercept_only) ? $this->legal_intercept_only : null;
    }
    /**
     * Set legal_intercept_only value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $legal_intercept_only
     * @return \StructType\GetAccountListRequest
     */
    public function setLegal_intercept_only($legal_intercept_only = null)
    {
        // validation for constraint: int
        if (!is_null($legal_intercept_only) && !is_numeric($legal_intercept_only)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($legal_intercept_only)), __LINE__);
        }
        if (is_null($legal_intercept_only) || (is_array($legal_intercept_only) && empty($legal_intercept_only))) {
            unset($this->legal_intercept_only);
        } else {
            $this->legal_intercept_only = $legal_intercept_only;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
