<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAccountCustomFieldsSchemaResponse StructType
 * @subpackage Structs
 */
class GetAccountCustomFieldsSchemaResponse extends AbstractStructBase
{
    /**
     * The custom_fields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:CustomFieldsInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\CustomFieldsInfo[]
     */
    public $custom_fields;
    /**
     * Constructor method for GetAccountCustomFieldsSchemaResponse
     * @uses GetAccountCustomFieldsSchemaResponse::setCustom_fields()
     * @param \StructType\CustomFieldsInfo[] $custom_fields
     */
    public function __construct(array $custom_fields = array())
    {
        $this
            ->setCustom_fields($custom_fields);
    }
    /**
     * Get custom_fields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomFieldsInfo[]|null
     */
    public function getCustom_fields()
    {
        return isset($this->custom_fields) ? $this->custom_fields : null;
    }
    /**
     * Set custom_fields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsInfo[] $custom_fields
     * @return \StructType\GetAccountCustomFieldsSchemaResponse
     */
    public function setCustom_fields(array $custom_fields = array())
    {
        foreach ($custom_fields as $getAccountCustomFieldsSchemaResponseCustom_fieldsItem) {
            // validation for constraint: itemType
            if (!$getAccountCustomFieldsSchemaResponseCustom_fieldsItem instanceof \StructType\CustomFieldsInfo) {
                throw new \InvalidArgumentException(sprintf('The custom_fields property can only contain items of \StructType\CustomFieldsInfo, "%s" given', is_object($getAccountCustomFieldsSchemaResponseCustom_fieldsItem) ? get_class($getAccountCustomFieldsSchemaResponseCustom_fieldsItem) : gettype($getAccountCustomFieldsSchemaResponseCustom_fieldsItem)), __LINE__);
            }
        }
        if (is_null($custom_fields) || (is_array($custom_fields) && empty($custom_fields))) {
            unset($this->custom_fields);
        } else {
            $this->custom_fields = $custom_fields;
        }
        return $this;
    }
    /**
     * Add item to custom_fields value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomFieldsInfo $item
     * @return \StructType\GetAccountCustomFieldsSchemaResponse
     */
    public function addToCustom_fields(\StructType\CustomFieldsInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomFieldsInfo) {
            throw new \InvalidArgumentException(sprintf('The custom_fields property can only contain items of \StructType\CustomFieldsInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->custom_fields[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetAccountCustomFieldsSchemaResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
