<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationPrefixInfo StructType
 * @subpackage Structs
 */
class DestinationPrefixInfo extends AbstractStructBase
{
    /**
     * The i_dest
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_dest;
    /**
     * The destination
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $destination;
    /**
     * The country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $country;
    /**
     * The subdivision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $subdivision;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The dest_type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dest_type;
    /**
     * The iso_3166_1_a2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_3166_1_a2;
    /**
     * The iso_3166_1_a3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iso_3166_1_a3;
    /**
     * The i_country_subdivision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_country_subdivision;
    /**
     * Constructor method for DestinationPrefixInfo
     * @uses DestinationPrefixInfo::setI_dest()
     * @uses DestinationPrefixInfo::setDestination()
     * @uses DestinationPrefixInfo::setCountry()
     * @uses DestinationPrefixInfo::setSubdivision()
     * @uses DestinationPrefixInfo::setDescription()
     * @uses DestinationPrefixInfo::setDest_type()
     * @uses DestinationPrefixInfo::setIso_3166_1_a2()
     * @uses DestinationPrefixInfo::setIso_3166_1_a3()
     * @uses DestinationPrefixInfo::setI_country_subdivision()
     * @param int $i_dest
     * @param string $destination
     * @param string $country
     * @param string $subdivision
     * @param string $description
     * @param string $dest_type
     * @param string $iso_3166_1_a2
     * @param string $iso_3166_1_a3
     * @param int $i_country_subdivision
     */
    public function __construct($i_dest = null, $destination = null, $country = null, $subdivision = null, $description = null, $dest_type = null, $iso_3166_1_a2 = null, $iso_3166_1_a3 = null, $i_country_subdivision = null)
    {
        $this
            ->setI_dest($i_dest)
            ->setDestination($destination)
            ->setCountry($country)
            ->setSubdivision($subdivision)
            ->setDescription($description)
            ->setDest_type($dest_type)
            ->setIso_3166_1_a2($iso_3166_1_a2)
            ->setIso_3166_1_a3($iso_3166_1_a3)
            ->setI_country_subdivision($i_country_subdivision);
    }
    /**
     * Get i_dest value
     * @return int
     */
    public function getI_dest()
    {
        return $this->i_dest;
    }
    /**
     * Set i_dest value
     * @param int $i_dest
     * @return \StructType\DestinationPrefixInfo
     */
    public function setI_dest($i_dest = null)
    {
        // validation for constraint: int
        if (!is_null($i_dest) && !is_numeric($i_dest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_dest)), __LINE__);
        }
        $this->i_dest = $i_dest;
        return $this;
    }
    /**
     * Get destination value
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }
    /**
     * Set destination value
     * @param string $destination
     * @return \StructType\DestinationPrefixInfo
     */
    public function setDestination($destination = null)
    {
        // validation for constraint: string
        if (!is_null($destination) && !is_string($destination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($destination)), __LINE__);
        }
        $this->destination = $destination;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \StructType\DestinationPrefixInfo
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get subdivision value
     * @return string|null
     */
    public function getSubdivision()
    {
        return $this->subdivision;
    }
    /**
     * Set subdivision value
     * @param string $subdivision
     * @return \StructType\DestinationPrefixInfo
     */
    public function setSubdivision($subdivision = null)
    {
        // validation for constraint: string
        if (!is_null($subdivision) && !is_string($subdivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subdivision)), __LINE__);
        }
        $this->subdivision = $subdivision;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\DestinationPrefixInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get dest_type value
     * @return string|null
     */
    public function getDest_type()
    {
        return $this->dest_type;
    }
    /**
     * Set dest_type value
     * @param string $dest_type
     * @return \StructType\DestinationPrefixInfo
     */
    public function setDest_type($dest_type = null)
    {
        // validation for constraint: string
        if (!is_null($dest_type) && !is_string($dest_type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dest_type)), __LINE__);
        }
        $this->dest_type = $dest_type;
        return $this;
    }
    /**
     * Get iso_3166_1_a2 value
     * @return string|null
     */
    public function getIso_3166_1_a2()
    {
        return $this->iso_3166_1_a2;
    }
    /**
     * Set iso_3166_1_a2 value
     * @param string $iso_3166_1_a2
     * @return \StructType\DestinationPrefixInfo
     */
    public function setIso_3166_1_a2($iso_3166_1_a2 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_3166_1_a2) && !is_string($iso_3166_1_a2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_3166_1_a2)), __LINE__);
        }
        $this->iso_3166_1_a2 = $iso_3166_1_a2;
        return $this;
    }
    /**
     * Get iso_3166_1_a3 value
     * @return string|null
     */
    public function getIso_3166_1_a3()
    {
        return $this->iso_3166_1_a3;
    }
    /**
     * Set iso_3166_1_a3 value
     * @param string $iso_3166_1_a3
     * @return \StructType\DestinationPrefixInfo
     */
    public function setIso_3166_1_a3($iso_3166_1_a3 = null)
    {
        // validation for constraint: string
        if (!is_null($iso_3166_1_a3) && !is_string($iso_3166_1_a3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iso_3166_1_a3)), __LINE__);
        }
        $this->iso_3166_1_a3 = $iso_3166_1_a3;
        return $this;
    }
    /**
     * Get i_country_subdivision value
     * @return int|null
     */
    public function getI_country_subdivision()
    {
        return $this->i_country_subdivision;
    }
    /**
     * Set i_country_subdivision value
     * @param int $i_country_subdivision
     * @return \StructType\DestinationPrefixInfo
     */
    public function setI_country_subdivision($i_country_subdivision = null)
    {
        // validation for constraint: int
        if (!is_null($i_country_subdivision) && !is_numeric($i_country_subdivision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_country_subdivision)), __LINE__);
        }
        $this->i_country_subdivision = $i_country_subdivision;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DestinationPrefixInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
