<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSiteInfo StructType
 * @subpackage Structs
 */
class CustomerSiteInfo extends AbstractStructBase
{
    /**
     * The i_customer_site
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer_site;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The service_features
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * - arrayType: pst:ServiceFeatureInfo[]
     * - ref: soapenc:arrayType
     * @var \StructType\ServiceFeatureInfo[]
     */
    public $service_features;
    /**
     * Constructor method for CustomerSiteInfo
     * @uses CustomerSiteInfo::setI_customer_site()
     * @uses CustomerSiteInfo::setName()
     * @uses CustomerSiteInfo::setI_customer()
     * @uses CustomerSiteInfo::setService_features()
     * @param int $i_customer_site
     * @param string $name
     * @param int $i_customer
     * @param \StructType\ServiceFeatureInfo[] $service_features
     */
    public function __construct($i_customer_site = null, $name = null, $i_customer = null, array $service_features = array())
    {
        $this
            ->setI_customer_site($i_customer_site)
            ->setName($name)
            ->setI_customer($i_customer)
            ->setService_features($service_features);
    }
    /**
     * Get i_customer_site value
     * @return int
     */
    public function getI_customer_site()
    {
        return $this->i_customer_site;
    }
    /**
     * Set i_customer_site value
     * @param int $i_customer_site
     * @return \StructType\CustomerSiteInfo
     */
    public function setI_customer_site($i_customer_site = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer_site) && !is_numeric($i_customer_site)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer_site)), __LINE__);
        }
        $this->i_customer_site = $i_customer_site;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\CustomerSiteInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CustomerSiteInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get service_features value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ServiceFeatureInfo[]|null
     */
    public function getService_features()
    {
        return isset($this->service_features) ? $this->service_features : null;
    }
    /**
     * Set service_features value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo[] $service_features
     * @return \StructType\CustomerSiteInfo
     */
    public function setService_features(array $service_features = array())
    {
        foreach ($service_features as $customerSiteInfoService_featuresItem) {
            // validation for constraint: itemType
            if (!$customerSiteInfoService_featuresItem instanceof \StructType\ServiceFeatureInfo) {
                throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($customerSiteInfoService_featuresItem) ? get_class($customerSiteInfoService_featuresItem) : gettype($customerSiteInfoService_featuresItem)), __LINE__);
            }
        }
        if (is_null($service_features) || (is_array($service_features) && empty($service_features))) {
            unset($this->service_features);
        } else {
            $this->service_features = $service_features;
        }
        return $this;
    }
    /**
     * Add item to service_features value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceFeatureInfo $item
     * @return \StructType\CustomerSiteInfo
     */
    public function addToService_features(\StructType\ServiceFeatureInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceFeatureInfo) {
            throw new \InvalidArgumentException(sprintf('The service_features property can only contain items of \StructType\ServiceFeatureInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->service_features[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerSiteInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
