<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerDIDNumberInfo StructType
 * @subpackage Structs
 */
class CustomerDIDNumberInfo extends AbstractStructBase
{
    /**
     * The i_did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_did_number;
    /**
     * The did_number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $did_number;
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_customer;
    /**
     * The is_provisioned
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $is_provisioned;
    /**
     * The area_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $area_name;
    /**
     * The country_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $country_name;
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_account;
    /**
     * The i_master_account
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_master_account;
    /**
     * The master_account_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $master_account_id;
    /**
     * The extension_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $extension_id;
    /**
     * The extension_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $extension_name;
    /**
     * The pricing
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\DIDPricing
     */
    public $pricing;
    /**
     * Constructor method for CustomerDIDNumberInfo
     * @uses CustomerDIDNumberInfo::setI_did_number()
     * @uses CustomerDIDNumberInfo::setDid_number()
     * @uses CustomerDIDNumberInfo::setI_customer()
     * @uses CustomerDIDNumberInfo::setIs_provisioned()
     * @uses CustomerDIDNumberInfo::setArea_name()
     * @uses CustomerDIDNumberInfo::setCountry_name()
     * @uses CustomerDIDNumberInfo::setI_account()
     * @uses CustomerDIDNumberInfo::setI_master_account()
     * @uses CustomerDIDNumberInfo::setMaster_account_id()
     * @uses CustomerDIDNumberInfo::setExtension_id()
     * @uses CustomerDIDNumberInfo::setExtension_name()
     * @uses CustomerDIDNumberInfo::setPricing()
     * @param int $i_did_number
     * @param string $did_number
     * @param int $i_customer
     * @param int $is_provisioned
     * @param string $area_name
     * @param string $country_name
     * @param int $i_account
     * @param int $i_master_account
     * @param string $master_account_id
     * @param string $extension_id
     * @param string $extension_name
     * @param \StructType\DIDPricing $pricing
     */
    public function __construct($i_did_number = null, $did_number = null, $i_customer = null, $is_provisioned = null, $area_name = null, $country_name = null, $i_account = null, $i_master_account = null, $master_account_id = null, $extension_id = null, $extension_name = null, \StructType\DIDPricing $pricing = null)
    {
        $this
            ->setI_did_number($i_did_number)
            ->setDid_number($did_number)
            ->setI_customer($i_customer)
            ->setIs_provisioned($is_provisioned)
            ->setArea_name($area_name)
            ->setCountry_name($country_name)
            ->setI_account($i_account)
            ->setI_master_account($i_master_account)
            ->setMaster_account_id($master_account_id)
            ->setExtension_id($extension_id)
            ->setExtension_name($extension_name)
            ->setPricing($pricing);
    }
    /**
     * Get i_did_number value
     * @return int|null
     */
    public function getI_did_number()
    {
        return $this->i_did_number;
    }
    /**
     * Set i_did_number value
     * @param int $i_did_number
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setI_did_number($i_did_number = null)
    {
        // validation for constraint: int
        if (!is_null($i_did_number) && !is_numeric($i_did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_did_number)), __LINE__);
        }
        $this->i_did_number = $i_did_number;
        return $this;
    }
    /**
     * Get did_number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDid_number()
    {
        return isset($this->did_number) ? $this->did_number : null;
    }
    /**
     * Set did_number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $did_number
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setDid_number($did_number = null)
    {
        // validation for constraint: string
        if (!is_null($did_number) && !is_string($did_number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($did_number)), __LINE__);
        }
        if (is_null($did_number) || (is_array($did_number) && empty($did_number))) {
            unset($this->did_number);
        } else {
            $this->did_number = $did_number;
        }
        return $this;
    }
    /**
     * Get i_customer value
     * @return int|null
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get is_provisioned value
     * @return int|null
     */
    public function getIs_provisioned()
    {
        return $this->is_provisioned;
    }
    /**
     * Set is_provisioned value
     * @param int $is_provisioned
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setIs_provisioned($is_provisioned = null)
    {
        // validation for constraint: int
        if (!is_null($is_provisioned) && !is_numeric($is_provisioned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($is_provisioned)), __LINE__);
        }
        $this->is_provisioned = $is_provisioned;
        return $this;
    }
    /**
     * Get area_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArea_name()
    {
        return isset($this->area_name) ? $this->area_name : null;
    }
    /**
     * Set area_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $area_name
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setArea_name($area_name = null)
    {
        // validation for constraint: string
        if (!is_null($area_name) && !is_string($area_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($area_name)), __LINE__);
        }
        if (is_null($area_name) || (is_array($area_name) && empty($area_name))) {
            unset($this->area_name);
        } else {
            $this->area_name = $area_name;
        }
        return $this;
    }
    /**
     * Get country_name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry_name()
    {
        return isset($this->country_name) ? $this->country_name : null;
    }
    /**
     * Set country_name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country_name
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setCountry_name($country_name = null)
    {
        // validation for constraint: string
        if (!is_null($country_name) && !is_string($country_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country_name)), __LINE__);
        }
        if (is_null($country_name) || (is_array($country_name) && empty($country_name))) {
            unset($this->country_name);
        } else {
            $this->country_name = $country_name;
        }
        return $this;
    }
    /**
     * Get i_account value
     * @return int|null
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get i_master_account value
     * @return int|null
     */
    public function getI_master_account()
    {
        return $this->i_master_account;
    }
    /**
     * Set i_master_account value
     * @param int $i_master_account
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setI_master_account($i_master_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_master_account) && !is_numeric($i_master_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_master_account)), __LINE__);
        }
        $this->i_master_account = $i_master_account;
        return $this;
    }
    /**
     * Get master_account_id value
     * @return string|null
     */
    public function getMaster_account_id()
    {
        return $this->master_account_id;
    }
    /**
     * Set master_account_id value
     * @param string $master_account_id
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setMaster_account_id($master_account_id = null)
    {
        // validation for constraint: string
        if (!is_null($master_account_id) && !is_string($master_account_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($master_account_id)), __LINE__);
        }
        $this->master_account_id = $master_account_id;
        return $this;
    }
    /**
     * Get extension_id value
     * @return string|null
     */
    public function getExtension_id()
    {
        return $this->extension_id;
    }
    /**
     * Set extension_id value
     * @param string $extension_id
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setExtension_id($extension_id = null)
    {
        // validation for constraint: string
        if (!is_null($extension_id) && !is_string($extension_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension_id)), __LINE__);
        }
        $this->extension_id = $extension_id;
        return $this;
    }
    /**
     * Get extension_name value
     * @return string|null
     */
    public function getExtension_name()
    {
        return $this->extension_name;
    }
    /**
     * Set extension_name value
     * @param string $extension_name
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setExtension_name($extension_name = null)
    {
        // validation for constraint: string
        if (!is_null($extension_name) && !is_string($extension_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($extension_name)), __LINE__);
        }
        $this->extension_name = $extension_name;
        return $this;
    }
    /**
     * Get pricing value
     * @return \StructType\DIDPricing|null
     */
    public function getPricing()
    {
        return $this->pricing;
    }
    /**
     * Set pricing value
     * @param \StructType\DIDPricing $pricing
     * @return \StructType\CustomerDIDNumberInfo
     */
    public function setPricing(\StructType\DIDPricing $pricing = null)
    {
        $this->pricing = $pricing;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerDIDNumberInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
