<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsumedServiceInfo StructType
 * @subpackage Structs
 */
class ConsumedServiceInfo extends AbstractStructBase
{
    /**
     * The i_service
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $i_service;
    /**
     * The service_name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $service_name;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $unit;
    /**
     * The charged_amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $charged_amount;
    /**
     * The charged_quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $charged_quantity;
    /**
     * The total
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total;
    /**
     * The total_sessions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $total_sessions;
    /**
     * The rating_base
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rating_base;
    /**
     * The rate_unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rate_unit;
    /**
     * Constructor method for ConsumedServiceInfo
     * @uses ConsumedServiceInfo::setI_service()
     * @uses ConsumedServiceInfo::setService_name()
     * @uses ConsumedServiceInfo::setUnit()
     * @uses ConsumedServiceInfo::setCharged_amount()
     * @uses ConsumedServiceInfo::setCharged_quantity()
     * @uses ConsumedServiceInfo::setTotal()
     * @uses ConsumedServiceInfo::setTotal_sessions()
     * @uses ConsumedServiceInfo::setRating_base()
     * @uses ConsumedServiceInfo::setRate_unit()
     * @param int $i_service
     * @param string $service_name
     * @param string $unit
     * @param string $charged_amount
     * @param int $charged_quantity
     * @param int $total
     * @param int $total_sessions
     * @param string $rating_base
     * @param string $rate_unit
     */
    public function __construct($i_service = null, $service_name = null, $unit = null, $charged_amount = null, $charged_quantity = null, $total = null, $total_sessions = null, $rating_base = null, $rate_unit = null)
    {
        $this
            ->setI_service($i_service)
            ->setService_name($service_name)
            ->setUnit($unit)
            ->setCharged_amount($charged_amount)
            ->setCharged_quantity($charged_quantity)
            ->setTotal($total)
            ->setTotal_sessions($total_sessions)
            ->setRating_base($rating_base)
            ->setRate_unit($rate_unit);
    }
    /**
     * Get i_service value
     * @return int|null
     */
    public function getI_service()
    {
        return $this->i_service;
    }
    /**
     * Set i_service value
     * @param int $i_service
     * @return \StructType\ConsumedServiceInfo
     */
    public function setI_service($i_service = null)
    {
        // validation for constraint: int
        if (!is_null($i_service) && !is_numeric($i_service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_service)), __LINE__);
        }
        $this->i_service = $i_service;
        return $this;
    }
    /**
     * Get service_name value
     * @return string|null
     */
    public function getService_name()
    {
        return $this->service_name;
    }
    /**
     * Set service_name value
     * @param string $service_name
     * @return \StructType\ConsumedServiceInfo
     */
    public function setService_name($service_name = null)
    {
        // validation for constraint: string
        if (!is_null($service_name) && !is_string($service_name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($service_name)), __LINE__);
        }
        $this->service_name = $service_name;
        return $this;
    }
    /**
     * Get unit value
     * @return string|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param string $unit
     * @return \StructType\ConsumedServiceInfo
     */
    public function setUnit($unit = null)
    {
        // validation for constraint: string
        if (!is_null($unit) && !is_string($unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unit)), __LINE__);
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get charged_amount value
     * @return string|null
     */
    public function getCharged_amount()
    {
        return $this->charged_amount;
    }
    /**
     * Set charged_amount value
     * @param string $charged_amount
     * @return \StructType\ConsumedServiceInfo
     */
    public function setCharged_amount($charged_amount = null)
    {
        // validation for constraint: string
        if (!is_null($charged_amount) && !is_string($charged_amount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charged_amount)), __LINE__);
        }
        $this->charged_amount = $charged_amount;
        return $this;
    }
    /**
     * Get charged_quantity value
     * @return int|null
     */
    public function getCharged_quantity()
    {
        return $this->charged_quantity;
    }
    /**
     * Set charged_quantity value
     * @param int $charged_quantity
     * @return \StructType\ConsumedServiceInfo
     */
    public function setCharged_quantity($charged_quantity = null)
    {
        // validation for constraint: int
        if (!is_null($charged_quantity) && !is_numeric($charged_quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($charged_quantity)), __LINE__);
        }
        $this->charged_quantity = $charged_quantity;
        return $this;
    }
    /**
     * Get total value
     * @return int|null
     */
    public function getTotal()
    {
        return $this->total;
    }
    /**
     * Set total value
     * @param int $total
     * @return \StructType\ConsumedServiceInfo
     */
    public function setTotal($total = null)
    {
        // validation for constraint: int
        if (!is_null($total) && !is_numeric($total)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total)), __LINE__);
        }
        $this->total = $total;
        return $this;
    }
    /**
     * Get total_sessions value
     * @return int|null
     */
    public function getTotal_sessions()
    {
        return $this->total_sessions;
    }
    /**
     * Set total_sessions value
     * @param int $total_sessions
     * @return \StructType\ConsumedServiceInfo
     */
    public function setTotal_sessions($total_sessions = null)
    {
        // validation for constraint: int
        if (!is_null($total_sessions) && !is_numeric($total_sessions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($total_sessions)), __LINE__);
        }
        $this->total_sessions = $total_sessions;
        return $this;
    }
    /**
     * Get rating_base value
     * @return string|null
     */
    public function getRating_base()
    {
        return $this->rating_base;
    }
    /**
     * Set rating_base value
     * @param string $rating_base
     * @return \StructType\ConsumedServiceInfo
     */
    public function setRating_base($rating_base = null)
    {
        // validation for constraint: string
        if (!is_null($rating_base) && !is_string($rating_base)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rating_base)), __LINE__);
        }
        $this->rating_base = $rating_base;
        return $this;
    }
    /**
     * Get rate_unit value
     * @return string|null
     */
    public function getRate_unit()
    {
        return $this->rate_unit;
    }
    /**
     * Set rate_unit value
     * @param string $rate_unit
     * @return \StructType\ConsumedServiceInfo
     */
    public function setRate_unit($rate_unit = null)
    {
        // validation for constraint: string
        if (!is_null($rate_unit) && !is_string($rate_unit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rate_unit)), __LINE__);
        }
        $this->rate_unit = $rate_unit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConsumedServiceInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
