<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallBarringRuleInfo StructType
 * @subpackage Structs
 */
class CallBarringRuleInfo extends AbstractStructBase
{
    /**
     * The i_cp_condition
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_cp_condition;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var string
     */
    public $state;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The rule_description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $rule_description;
    /**
     * Constructor method for CallBarringRuleInfo
     * @uses CallBarringRuleInfo::setI_cp_condition()
     * @uses CallBarringRuleInfo::setState()
     * @uses CallBarringRuleInfo::setName()
     * @uses CallBarringRuleInfo::setRule_description()
     * @param int $i_cp_condition
     * @param string $state
     * @param string $name
     * @param string $rule_description
     */
    public function __construct($i_cp_condition = null, $state = null, $name = null, $rule_description = null)
    {
        $this
            ->setI_cp_condition($i_cp_condition)
            ->setState($state)
            ->setName($name)
            ->setRule_description($rule_description);
    }
    /**
     * Get i_cp_condition value
     * @return int
     */
    public function getI_cp_condition()
    {
        return $this->i_cp_condition;
    }
    /**
     * Set i_cp_condition value
     * @param int $i_cp_condition
     * @return \StructType\CallBarringRuleInfo
     */
    public function setI_cp_condition($i_cp_condition = null)
    {
        // validation for constraint: int
        if (!is_null($i_cp_condition) && !is_numeric($i_cp_condition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_cp_condition)), __LINE__);
        }
        $this->i_cp_condition = $i_cp_condition;
        return $this;
    }
    /**
     * Get state value
     * @return string
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @param string $state
     * @return \StructType\CallBarringRuleInfo
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->name) ? $this->name : null;
    }
    /**
     * Set name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\CallBarringRuleInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->name);
        } else {
            $this->name = $name;
        }
        return $this;
    }
    /**
     * Get rule_description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRule_description()
    {
        return isset($this->rule_description) ? $this->rule_description : null;
    }
    /**
     * Set rule_description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rule_description
     * @return \StructType\CallBarringRuleInfo
     */
    public function setRule_description($rule_description = null)
    {
        // validation for constraint: string
        if (!is_null($rule_description) && !is_string($rule_description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rule_description)), __LINE__);
        }
        if (is_null($rule_description) || (is_array($rule_description) && empty($rule_description))) {
            unset($this->rule_description);
        } else {
            $this->rule_description = $rule_description;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CallBarringRuleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
