<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoPaymentInfo StructType
 * @subpackage Structs
 */
class AutoPaymentInfo extends AbstractStructBase
{
    /**
     * The i_object
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $i_object;
    /**
     * The object
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $object;
    /**
     * The pay_amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $pay_amount;
    /**
     * The balance_threshold
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $balance_threshold;
    /**
     * The frozen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $frozen;
    /**
     * Constructor method for AutoPaymentInfo
     * @uses AutoPaymentInfo::setI_object()
     * @uses AutoPaymentInfo::setObject()
     * @uses AutoPaymentInfo::setPay_amount()
     * @uses AutoPaymentInfo::setBalance_threshold()
     * @uses AutoPaymentInfo::setFrozen()
     * @param int $i_object
     * @param string $object
     * @param float $pay_amount
     * @param float $balance_threshold
     * @param string $frozen
     */
    public function __construct($i_object = null, $object = null, $pay_amount = null, $balance_threshold = null, $frozen = null)
    {
        $this
            ->setI_object($i_object)
            ->setObject($object)
            ->setPay_amount($pay_amount)
            ->setBalance_threshold($balance_threshold)
            ->setFrozen($frozen);
    }
    /**
     * Get i_object value
     * @return int|null
     */
    public function getI_object()
    {
        return $this->i_object;
    }
    /**
     * Set i_object value
     * @param int $i_object
     * @return \StructType\AutoPaymentInfo
     */
    public function setI_object($i_object = null)
    {
        // validation for constraint: int
        if (!is_null($i_object) && !is_numeric($i_object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_object)), __LINE__);
        }
        $this->i_object = $i_object;
        return $this;
    }
    /**
     * Get object value
     * @return string|null
     */
    public function getObject()
    {
        return $this->object;
    }
    /**
     * Set object value
     * @param string $object
     * @return \StructType\AutoPaymentInfo
     */
    public function setObject($object = null)
    {
        // validation for constraint: string
        if (!is_null($object) && !is_string($object)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($object)), __LINE__);
        }
        $this->object = $object;
        return $this;
    }
    /**
     * Get pay_amount value
     * @return float|null
     */
    public function getPay_amount()
    {
        return $this->pay_amount;
    }
    /**
     * Set pay_amount value
     * @param float $pay_amount
     * @return \StructType\AutoPaymentInfo
     */
    public function setPay_amount($pay_amount = null)
    {
        $this->pay_amount = $pay_amount;
        return $this;
    }
    /**
     * Get balance_threshold value
     * @return float|null
     */
    public function getBalance_threshold()
    {
        return $this->balance_threshold;
    }
    /**
     * Set balance_threshold value
     * @param float $balance_threshold
     * @return \StructType\AutoPaymentInfo
     */
    public function setBalance_threshold($balance_threshold = null)
    {
        $this->balance_threshold = $balance_threshold;
        return $this;
    }
    /**
     * Get frozen value
     * @return string|null
     */
    public function getFrozen()
    {
        return $this->frozen;
    }
    /**
     * Set frozen value
     * @param string $frozen
     * @return \StructType\AutoPaymentInfo
     */
    public function setFrozen($frozen = null)
    {
        // validation for constraint: string
        if (!is_null($frozen) && !is_string($frozen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($frozen)), __LINE__);
        }
        $this->frozen = $frozen;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AutoPaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
