<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthInfoStructure StructType
 * @subpackage Structs
 */
class AuthInfoStructure extends AbstractStructBase
{
    /**
     * The session_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $session_id;
    /**
     * The login
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * Constructor method for AuthInfoStructure
     * @uses AuthInfoStructure::setSession_id()
     * @uses AuthInfoStructure::setLogin()
     * @uses AuthInfoStructure::setPassword()
     * @param string $session_id
     * @param string $login
     * @param string $password
     */
    public function __construct($session_id = null, $login = null, $password = null)
    {
        $this
            ->setSession_id($session_id)
            ->setLogin($login)
            ->setPassword($password);
    }
    /**
     * Get session_id value
     * @return string|null
     */
    public function getSession_id()
    {
        return $this->session_id;
    }
    /**
     * Set session_id value
     * @param string $session_id
     * @return \StructType\AuthInfoStructure
     */
    public function setSession_id($session_id = null)
    {
        // validation for constraint: string
        if (!is_null($session_id) && !is_string($session_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($session_id)), __LINE__);
        }
        $this->session_id = $session_id;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\AuthInfoStructure
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\AuthInfoStructure
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AuthInfoStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
