<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AttributePermission StructType
 * @subpackage Structs
 */
class AttributePermission extends AbstractStructBase
{
    /**
     * The attribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $attribute;
    /**
     * The permissions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $permissions;
    /**
     * Constructor method for AttributePermission
     * @uses AttributePermission::setAttribute()
     * @uses AttributePermission::setPermissions()
     * @param string $attribute
     * @param string $permissions
     */
    public function __construct($attribute = null, $permissions = null)
    {
        $this
            ->setAttribute($attribute)
            ->setPermissions($permissions);
    }
    /**
     * Get attribute value
     * @return string
     */
    public function getAttribute()
    {
        return $this->attribute;
    }
    /**
     * Set attribute value
     * @param string $attribute
     * @return \StructType\AttributePermission
     */
    public function setAttribute($attribute = null)
    {
        // validation for constraint: string
        if (!is_null($attribute) && !is_string($attribute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($attribute)), __LINE__);
        }
        $this->attribute = $attribute;
        return $this;
    }
    /**
     * Get permissions value
     * @return string
     */
    public function getPermissions()
    {
        return $this->permissions;
    }
    /**
     * Set permissions value
     * @param string $permissions
     * @return \StructType\AttributePermission
     */
    public function setPermissions($permissions = null)
    {
        // validation for constraint: string
        if (!is_null($permissions) && !is_string($permissions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($permissions)), __LINE__);
        }
        $this->permissions = $permissions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AttributePermission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
