<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrangeFollowMeNumbersRequest StructType
 * @subpackage Structs
 */
class ArrangeFollowMeNumbersRequest extends AbstractStructBase
{
    /**
     * The i_account
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $i_account;
    /**
     * The numbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - arrayType: int[]
     * - ref: soapenc:arrayType
     * @var int[]
     */
    public $numbers;
    /**
     * Constructor method for ArrangeFollowMeNumbersRequest
     * @uses ArrangeFollowMeNumbersRequest::setI_account()
     * @uses ArrangeFollowMeNumbersRequest::setNumbers()
     * @param int $i_account
     * @param int[] $numbers
     */
    public function __construct($i_account = null, array $numbers = array())
    {
        $this
            ->setI_account($i_account)
            ->setNumbers($numbers);
    }
    /**
     * Get i_account value
     * @return int
     */
    public function getI_account()
    {
        return $this->i_account;
    }
    /**
     * Set i_account value
     * @param int $i_account
     * @return \StructType\ArrangeFollowMeNumbersRequest
     */
    public function setI_account($i_account = null)
    {
        // validation for constraint: int
        if (!is_null($i_account) && !is_numeric($i_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_account)), __LINE__);
        }
        $this->i_account = $i_account;
        return $this;
    }
    /**
     * Get numbers value
     * @return int[]|null
     */
    public function getNumbers()
    {
        return $this->numbers;
    }
    /**
     * Set numbers value
     * @throws \InvalidArgumentException
     * @param int[] $numbers
     * @return \StructType\ArrangeFollowMeNumbersRequest
     */
    public function setNumbers(array $numbers = array())
    {
        foreach ($numbers as $arrangeFollowMeNumbersRequestNumbersItem) {
            // validation for constraint: itemType
            if (!is_numeric($arrangeFollowMeNumbersRequestNumbersItem)) {
                throw new \InvalidArgumentException(sprintf('The numbers property can only contain items of int, "%s" given', is_object($arrangeFollowMeNumbersRequestNumbersItem) ? get_class($arrangeFollowMeNumbersRequestNumbersItem) : gettype($arrangeFollowMeNumbersRequestNumbersItem)), __LINE__);
            }
        }
        $this->numbers = $numbers;
        return $this;
    }
    /**
     * Add item to numbers value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \StructType\ArrangeFollowMeNumbersRequest
     */
    public function addToNumbers($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The numbers property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->numbers[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArrangeFollowMeNumbersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
