<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddUpdateCustomerAbbreviatedDialingNumberRequest
 * StructType
 * @subpackage Structs
 */
class AddUpdateCustomerAbbreviatedDialingNumberRequest extends AbstractStructBase
{
    /**
     * The i_customer
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var int
     */
    public $i_customer;
    /**
     * The abbreviated_dialing_number_info
     * Meta informations extracted from the WSDL
     * - minOccurs: 1
     * @var \StructType\AbbreviatedDialingNumberInfo
     */
    public $abbreviated_dialing_number_info;
    /**
     * Constructor method for AddUpdateCustomerAbbreviatedDialingNumberRequest
     * @uses AddUpdateCustomerAbbreviatedDialingNumberRequest::setI_customer()
     * @uses AddUpdateCustomerAbbreviatedDialingNumberRequest::setAbbreviated_dialing_number_info()
     * @param int $i_customer
     * @param \StructType\AbbreviatedDialingNumberInfo $abbreviated_dialing_number_info
     */
    public function __construct($i_customer = null, \StructType\AbbreviatedDialingNumberInfo $abbreviated_dialing_number_info = null)
    {
        $this
            ->setI_customer($i_customer)
            ->setAbbreviated_dialing_number_info($abbreviated_dialing_number_info);
    }
    /**
     * Get i_customer value
     * @return int
     */
    public function getI_customer()
    {
        return $this->i_customer;
    }
    /**
     * Set i_customer value
     * @param int $i_customer
     * @return \StructType\AddUpdateCustomerAbbreviatedDialingNumberRequest
     */
    public function setI_customer($i_customer = null)
    {
        // validation for constraint: int
        if (!is_null($i_customer) && !is_numeric($i_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($i_customer)), __LINE__);
        }
        $this->i_customer = $i_customer;
        return $this;
    }
    /**
     * Get abbreviated_dialing_number_info value
     * @return \StructType\AbbreviatedDialingNumberInfo
     */
    public function getAbbreviated_dialing_number_info()
    {
        return $this->abbreviated_dialing_number_info;
    }
    /**
     * Set abbreviated_dialing_number_info value
     * @param \StructType\AbbreviatedDialingNumberInfo $abbreviated_dialing_number_info
     * @return \StructType\AddUpdateCustomerAbbreviatedDialingNumberRequest
     */
    public function setAbbreviated_dialing_number_info(\StructType\AbbreviatedDialingNumberInfo $abbreviated_dialing_number_info = null)
    {
        $this->abbreviated_dialing_number_info = $abbreviated_dialing_number_info;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddUpdateCustomerAbbreviatedDialingNumberRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
